use qbit;

use Test::Partner2::Simple;
use Test::More;
use Test::Differences;

my $fake_client_id = 1234;
my $fake_login     = 'FAKE_LOGIN';

my $fake_contracts = [
    {
        'Person' => {
            'signer_person_name'   => 'FAKE_SIGNER_PERSON_NAME',
            'person_account'       => 'FAKE_PERSON_ACCOUNT',
            'longname'             => 'FAKE_LONGNAME',
            'email'                => 'FAKE_EMAIL',
            'ben_account'          => 'FAKE_BEN_ACCOUNT',
            'legaladdress'         => 'FAKE_LEGALADDRESS',
            'authority_doc_type'   => 'FAKE_AUTHORITY_DOC_TYPE',
            'fax'                  => 'FAKE_FAX',
            'representative'       => 'FAKE_REPRESENTATIVE',
            'id'                   => 'FAKE_ID',
            'ben_bank'             => 'FAKE_BEN_BANK',
            'swift'                => 'FAKE_SWIFT',
            'postaddress'          => 'FAKE_POSTADDRESS',
            'account'              => 'FAKE_ACCOUNT',
            'name'                 => 'FAKE_NAME',
            'client_id'            => $fake_client_id,
            'phone'                => 'FAKE_PHONE',
            'login'                => $fake_login,
            'kpp'                  => 'FAKE_KPP',
            'inn'                  => 'FAKE_INN',
            'bik'                  => 'FAKE_BIK',
            'yamoney_wallet'       => 'FAKE_YAMONEY_WALLET',
            'iban'                 => 'FAKE_IBAN',
            'other'                => 'FAKE_OTHER',
            'signer_position_name' => 'FAKE_SIGNER_POSITION_NAME'
        },
        'Client'      => {},
        'Collaterals' => [
            {
                'partner_pct'        => '50',
                'is_faxed'           => '',
                'is_signed'          => '2016-07-20',
                'dt'                 => '2016-07-01',
                'collateral_type_id' => '2020',
                'class'              => 'COLLATERAL'
            },
            {
                'is_faxed'           => '',
                'is_signed'          => '2017-05-12',
                'dt'                 => '2017-05-02',
                'collateral_type_id' => '2040',
                'class'              => 'COLLATERAL'
            }
        ],
        'Contract' => {
            'is_faxed'      => '',
            'is_signed'     => '2016-06-03',
            'dt'            => '2016-06-01',
            'end_dt'        => '',
            'type'          => 'PARTNERS',
            'contract_type' => '9',
            'pay_to'        => '1',
            'reward_type'   => '1',
            'currency'      => '643',
            'external_id'   => 'FAKE_EXTERNAL_ID',
            'vat'           => undef,
            'test_mode'     => 1,
            'person_id'     => 'FAKE_ID',
            'firm'          => '1',
        }
    }
];

my $expected_active_for_partner = {
    'Person' => {
        'signer_person_name'   => 'FAKE_SIGNER_PERSON_NAME',
        'person_account'       => 'FAKE_PERSON_ACCOUNT',
        'longname'             => 'FAKE_LONGNAME',
        'email'                => 'FAKE_EMAIL',
        'ben_account'          => 'FAKE_BEN_ACCOUNT',
        'legaladdress'         => 'FAKE_LEGALADDRESS',
        'authority_doc_type'   => 'FAKE_AUTHORITY_DOC_TYPE',
        'fax'                  => 'FAKE_FAX',
        'representative'       => 'FAKE_REPRESENTATIVE',
        'ben_bank'             => 'FAKE_BEN_BANK',
        'swift'                => 'FAKE_SWIFT',
        'postaddress'          => 'FAKE_POSTADDRESS',
        'account'              => 'FAKE_ACCOUNT',
        'name'                 => 'FAKE_NAME',
        'phone'                => 'FAKE_PHONE',
        'kpp'                  => 'FAKE_KPP',
        'inn'                  => 'FAKE_INN',
        'bik'                  => 'FAKE_BIK',
        'iban'                 => 'FAKE_IBAN',
        'other'                => 'FAKE_OTHER',
        'signer_position_name' => 'FAKE_SIGNER_POSITION_NAME'
    },
    'Contract' => {
        'is_faxed'    => '',
        'vat'         => undef,
        'dt'          => '2016-06-01',
        'status'      => 'Offer test mode',
        'currency'    => '643',
        'external_id' => 'FAKE_EXTERNAL_ID',
        'is_signed'   => '2016-06-03',
        'pay_to'      => 1,
        'is_oferta2'  => 1,
        'firm'        => 1,
        'person_id'   => 'FAKE_ID',
        'test_mode'   => 1,
        contract_type => 9
    }
};

run_tests(
    sub {
        my ($app) = @_;

        {
            no warnings 'once';
            no warnings 'redefine';
            *Application::Model::Documents::get_raw_contracts = sub {
                my ($self, %opts) = @_;
                is_deeply(\%opts, {client_id => $fake_client_id,}, 'get_raw_contracts opts');
                return $fake_contracts;
            };
        }

        change_cur_user($app, 'mocked-yan-partner');
        eq_or_diff($app->documents->get_active_contract({client_id => $fake_client_id, login => $fake_login}),
            $expected_active_for_partner, 'get_active_contract return value');

    },
    init => [qw(documents)]
);
