use qbit;

use Test::Partner2::Simple;
use Test::More tests => 8;
use Test::Differences;

my $fake_client_id = 1234;
my $fake_login     = 'FAKE_LOGIN';

my $fake_contracts = [
    {
        'Person'      => {},
        'Client'      => {},
        'Collaterals' => [
            {
                'is_faxed'           => '2010-06-29',
                'is_signed'          => '2010-06-29',
                'dt'                 => '2010-05-31',
                'collateral_type_id' => '2070',
                'class'              => 'COLLATERAL'
            },
            {
                'is_faxed'           => '',
                'is_signed'          => '',
                'dt'                 => '2013-05-31',
                'collateral_type_id' => '2090',
                'end_reason'         => '2',
                'end_dt'             => '2013-05-31',
                'class'              => 'ANNOUNCEMENT'
            }
        ],
        'Contract' => {
            'is_faxed'      => '2010-06-29',
            'is_signed'     => '2010-06-29',
            'dt'            => '2009-09-23',
            'end_dt'        => '',
            'type'          => 'WRONG',
            'contract_type' => '1'
        }
    },
    {
        'Person'      => {},
        'Client'      => {},
        'Collaterals' => [],
        'Contract'    => {
            'is_faxed'      => '',
            'is_signed'     => '',
            'dt'            => '2008-07-22',
            'end_dt'        => '2009-08-28',
            'type'          => 'PARTNERS',
            'contract_type' => '1'
        }
    },
    {
        'Person'      => {},
        'Client'      => {},
        'Collaterals' => [
            {
                'partner_pct'        => '60',
                'is_faxed'           => '',
                'is_signed'          => '2014-01-30',
                'dt'                 => '2014-01-01',
                'collateral_type_id' => '2020',
                'class'              => 'COLLATERAL'
            },
            {
                'is_faxed'           => '',
                'is_signed'          => '2014-12-24',
                'dt'                 => '2014-10-23',
                'collateral_type_id' => '2040',
                'class'              => 'COLLATERAL'
            },
            {
                'is_faxed'           => '',
                'is_signed'          => '2014-12-29',
                'dt'                 => '2014-12-25',
                'collateral_type_id' => '9999',
                'class'              => 'COLLATERAL'
            },
            {
                'partner_pct'        => '43',
                'is_faxed'           => '',
                'is_signed'          => '2015-01-15',
                'dt'                 => '2015-01-01',
                'collateral_type_id' => '2020',
                'class'              => 'COLLATERAL'
            },
            {
                'is_faxed'           => '',
                'is_signed'          => '',
                'dt'                 => '2016-05-31',
                'collateral_type_id' => '2090',
                'end_reason'         => '1',
                'end_dt'             => '2016-05-31',
                'class'              => 'ANNOUNCEMENT'
            }
        ],
        'Contract' => {
            'is_faxed'      => '2013-04-30',
            'is_signed'     => '',
            'dt'            => '2013-06-01',
            'end_dt'        => '',
            'type'          => 'PARTNERS',
            'contract_type' => '5'
        }
    },
    {
        'Person' => {
            'signer_person_name'   => 'FAKE_SIGNER_PERSON_NAME',
            'person_account'       => 'FAKE_PERSON_ACCOUNT',
            'longname'             => 'FAKE_LONGNAME',
            'email'                => 'FAKE_EMAIL',
            'ben_account'          => 'FAKE_BEN_ACCOUNT',
            'legaladdress'         => 'FAKE_LEGALADDRESS',
            'authority_doc_type'   => 'FAKE_AUTHORITY_DOC_TYPE',
            'fax'                  => 'FAKE_FAX',
            'representative'       => 'FAKE_REPRESENTATIVE',
            'id'                   => 'FAKE_ID',
            'ben_bank'             => 'FAKE_BEN_BANK',
            'swift'                => 'FAKE_SWIFT',
            'postaddress'          => 'FAKE_POSTADDRESS',
            'account'              => 'FAKE_ACCOUNT',
            'name'                 => 'FAKE_NAME',
            'client_id'            => $fake_client_id,
            'phone'                => 'FAKE_PHONE',
            'login'                => $fake_login,
            'kpp'                  => 'FAKE_KPP',
            'inn'                  => 'FAKE_INN',
            'bik'                  => 'FAKE_BIK',
            'yamoney_wallet'       => 'FAKE_YAMONEY_WALLET',
            'iban'                 => 'FAKE_IBAN',
            'other'                => 'FAKE_OTHER',
            'signer_position_name' => 'FAKE_SIGNER_POSITION_NAME'
        },
        'Client'      => {},
        'Collaterals' => [
            {
                'partner_pct'        => '50',
                'is_faxed'           => '',
                'is_signed'          => '2016-07-20',
                'dt'                 => '2016-07-01',
                'collateral_type_id' => '2020',
                'class'              => 'COLLATERAL'
            },
            {
                'is_faxed'           => '',
                'is_signed'          => '2017-05-12',
                'dt'                 => '2017-05-02',
                'collateral_type_id' => '2040',
                'class'              => 'COLLATERAL'
            }
        ],
        'Contract' => {
            'is_faxed'      => '',
            'is_signed'     => '2016-06-03',
            'dt'            => '2016-06-01',
            'end_dt'        => '',
            'type'          => 'PARTNERS',
            'contract_type' => '6',
            'pay_to'        => '1',
            'reward_type'   => '1',
            'currency'      => '643',
            'external_id'   => 'FAKE_EXTERNAL_ID',
            'vat'           => undef,
        }
    }
];
my $expected = [
    {
        'Person'   => {},
        'Client'   => {},
        'Contract' => {
            'is_faxed'      => '',
            'dt'            => '2008-07-22',
            'is_signed'     => '',
            'type'          => 'PARTNERS',
            'end_dt'        => '2009-08-28',
            'contract_type' => '1'
        },
        'Collaterals' => []
    },
    {
        'Person'   => {},
        'Client'   => {},
        'Contract' => {
            'partner_pct'   => '43',
            'is_faxed'      => '2013-04-30',
            'dt'            => '2013-06-01',
            'agregator_pct' => undef,
            'is_signed'     => '',
            'end_reason'    => '1',
            'end_dt'        => '2016-05-31',
            'type'          => 'PARTNERS',
            'contract_type' => '5'
        },
        'Collaterals' => [
            {
                'partner_pct'        => '60',
                'is_faxed'           => '',
                'collateral_type_id' => '2020',
                'dt'                 => '2014-01-01',
                'is_signed'          => '2014-01-30',
                'class'              => 'COLLATERAL'
            },
            {
                'is_faxed'           => '',
                'collateral_type_id' => '2040',
                'dt'                 => '2014-10-23',
                'is_signed'          => '2014-12-24',
                'class'              => 'COLLATERAL'
            },
            {
                'is_faxed'           => '',
                'collateral_type_id' => '9999',
                'dt'                 => '2014-12-25',
                'is_signed'          => '2014-12-29',
                'class'              => 'COLLATERAL'
            },
            {
                'partner_pct'        => '43',
                'is_faxed'           => '',
                'collateral_type_id' => '2020',
                'dt'                 => '2015-01-01',
                'is_signed'          => '2015-01-15',
                'class'              => 'COLLATERAL'
            },
            {
                'is_faxed'           => '',
                'dt'                 => '2016-05-31',
                'is_signed'          => '',
                'collateral_type_id' => '2090',
                'end_reason'         => '1',
                'end_dt'             => '2016-05-31',
                'class'              => 'ANNOUNCEMENT'
            }
        ]
    },
    {
        'Person' => {
            'signer_person_name'   => 'FAKE_SIGNER_PERSON_NAME',
            'person_account'       => 'FAKE_PERSON_ACCOUNT',
            'longname'             => 'FAKE_LONGNAME',
            'email'                => 'FAKE_EMAIL',
            'ben_account'          => 'FAKE_BEN_ACCOUNT',
            'legaladdress'         => 'FAKE_LEGALADDRESS',
            'authority_doc_type'   => 'FAKE_AUTHORITY_DOC_TYPE',
            'fax'                  => 'FAKE_FAX',
            'representative'       => 'FAKE_REPRESENTATIVE',
            'id'                   => 'FAKE_ID',
            'ben_bank'             => 'FAKE_BEN_BANK',
            'swift'                => 'FAKE_SWIFT',
            'postaddress'          => 'FAKE_POSTADDRESS',
            'account'              => 'FAKE_ACCOUNT',
            'name'                 => 'FAKE_NAME',
            'client_id'            => $fake_client_id,
            'phone'                => 'FAKE_PHONE',
            'login'                => $fake_login,
            'kpp'                  => 'FAKE_KPP',
            'inn'                  => 'FAKE_INN',
            'bik'                  => 'FAKE_BIK',
            'yamoney_wallet'       => 'FAKE_YAMONEY_WALLET',
            'iban'                 => 'FAKE_IBAN',
            'other'                => 'FAKE_OTHER',
            'signer_position_name' => 'FAKE_SIGNER_POSITION_NAME'
        },
        'Client'   => {},
        'Contract' => {
            'partner_pct'   => '50',
            'is_faxed'      => '',
            'dt'            => '2016-06-01',
            'agregator_pct' => undef,
            'is_signed'     => '2016-06-03',
            'pay_to'        => 1,
            'end_dt'        => '',
            'type'          => 'PARTNERS',
            'contract_type' => '6',
            'pay_to'        => '1',
            'is_faxed'      => '',
            'vat'           => undef,
            'dt'            => '2016-06-01',
            'reward_type'   => '1',
            'currency'      => '643',
            'external_id'   => 'FAKE_EXTERNAL_ID',
            'is_signed'     => '2016-06-03'
        },
        'Collaterals' => [
            {
                'partner_pct'        => '50',
                'is_faxed'           => '',
                'collateral_type_id' => '2020',
                'dt'                 => '2016-07-01',
                'is_signed'          => '2016-07-20',
                'class'              => 'COLLATERAL'
            },
            {
                'is_faxed'           => '',
                'collateral_type_id' => '2040',
                'dt'                 => '2017-05-02',
                'is_signed'          => '2017-05-12',
                'class'              => 'COLLATERAL'
            }
        ]
    }
];

my $expected_active_for_partner = {
    'Person' => {
        'signer_person_name'   => 'FAKE_SIGNER_PERSON_NAME',
        'person_account'       => 'FAKE_PERSON_ACCOUNT',
        'longname'             => 'FAKE_LONGNAME',
        'email'                => 'FAKE_EMAIL',
        'ben_account'          => 'FAKE_BEN_ACCOUNT',
        'legaladdress'         => 'FAKE_LEGALADDRESS',
        'authority_doc_type'   => 'FAKE_AUTHORITY_DOC_TYPE',
        'fax'                  => 'FAKE_FAX',
        'representative'       => 'FAKE_REPRESENTATIVE',
        'ben_bank'             => 'FAKE_BEN_BANK',
        'swift'                => 'FAKE_SWIFT',
        'postaddress'          => 'FAKE_POSTADDRESS',
        'account'              => 'FAKE_ACCOUNT',
        'name'                 => 'FAKE_NAME',
        'phone'                => 'FAKE_PHONE',
        'kpp'                  => 'FAKE_KPP',
        'inn'                  => 'FAKE_INN',
        'bik'                  => 'FAKE_BIK',
        'iban'                 => 'FAKE_IBAN',
        'other'                => 'FAKE_OTHER',
        'signer_position_name' => 'FAKE_SIGNER_POSITION_NAME'
    },
    'Contract' => {
        'is_faxed'    => '',
        'vat'         => undef,
        'dt'          => '2016-06-01',
        'status'      => 'Signed 03.06.2016',
        'currency'    => '643',
        'external_id' => 'FAKE_EXTERNAL_ID',
        'is_signed'   => '2016-06-03',
        'pay_to'      => 1,
        contract_type => 6,
    }
};

my $expected_active_for_manager = {
    'Person' => {
        'id'                   => 'FAKE_ID',
        'client_id'            => $fake_client_id,
        'login'                => 'FAKE_LOGIN',
        'signer_person_name'   => 'FAKE_SIGNER_PERSON_NAME',
        'person_account'       => 'FAKE_PERSON_ACCOUNT',
        'longname'             => 'FAKE_LONGNAME',
        'email'                => 'FAKE_EMAIL',
        'ben_account'          => 'FAKE_BEN_ACCOUNT',
        'legaladdress'         => 'FAKE_LEGALADDRESS',
        'authority_doc_type'   => 'FAKE_AUTHORITY_DOC_TYPE',
        'fax'                  => 'FAKE_FAX',
        'representative'       => 'FAKE_REPRESENTATIVE',
        'ben_bank'             => 'FAKE_BEN_BANK',
        'swift'                => 'FAKE_SWIFT',
        'postaddress'          => 'FAKE_POSTADDRESS',
        'account'              => 'FAKE_ACCOUNT',
        'name'                 => 'FAKE_NAME',
        'phone'                => 'FAKE_PHONE',
        'kpp'                  => 'FAKE_KPP',
        'inn'                  => 'FAKE_INN',
        'bik'                  => 'FAKE_BIK',
        'iban'                 => 'FAKE_IBAN',
        'other'                => 'FAKE_OTHER',
        'signer_position_name' => 'FAKE_SIGNER_POSITION_NAME'
    },
    'Contract' => {
        'is_faxed'    => '',
        'vat'         => undef,
        'dt'          => '2016-06-01',
        'status'      => 'Signed 03.06.2016',
        'currency'    => '643',
        'external_id' => 'FAKE_EXTERNAL_ID',
        'is_signed'   => '2016-06-03',
        'pay_to'      => 1,
        'reward_type' => '1',
        contract_type => 6,
    }
};

run_tests(
    sub {
        my ($app) = @_;

        {
            no warnings 'once';
            no warnings 'redefine';
            *Application::Model::Documents::get_raw_contracts = sub {
                my ($self, %opts) = @_;
                is_deeply(\%opts, {client_id => $fake_client_id,}, 'get_raw_contracts opts');
                return $fake_contracts;
            };
        }

        change_cur_user($app, 'mocked-yan-partner');
        eq_or_diff($app->documents->get_contracts(client_id => $fake_client_id),
            $expected, 'get_contracts return value');
        eq_or_diff($app->documents->get_active_contract({client_id => $fake_client_id, login => $fake_login}),
            $expected_active_for_partner, 'get_active_contract return value');

        change_cur_user($app, 'mocked-yan-manager');
        eq_or_diff($app->documents->get_active_contract({client_id => $fake_client_id, login => $fake_login}),
            $expected_active_for_manager, 'get_active_contract return value');
    },
    init => [qw(documents)]
);
