#!/usr/bin/perl

use Test::Differences;
use Test::More tests => 4;

use qbit;

use Test::Partner::Utils qw(mock_curdate);
use Test::Partner2::Simple;

my $contract_list = [
    {
        Client      => {},
        Collaterals => [
            {
                class              => 'COLLATERAL',
                collateral_type_id => 2010,
                dt                 => '2020-02-19',
                is_signed          => 1,
                nds                => 620,
            },
            {
                class              => 'COLLATERAL',
                collateral_type_id => 2090,
                dt                 => '2020-02-21',
                end_dt             => '2020-02-21',
                is_signed          => 1,
            },
        ],
        Contract => {type => 'PARTNERS',},
        Person   => {},
    },
];

my $expected_contract = {
    'nds'  => 620,
    'type' => 'PARTNERS'
};

my $expected_contract_with_all_collaterals = {
    'end_dt'     => '2020-02-21',
    'end_reason' => undef,
    'nds'        => 620,
    'type'       => 'PARTNERS'
};

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate('2020-02-20 20:20:20');

        eq_or_diff $app->documents->get_contracts(contract_list => $contract_list,)->[0]{Contract}, $expected_contract,
          'contract with actual collaterals';
        eq_or_diff $app->documents->get_contracts(
            contract_list                  => $contract_list,
            skip_collateral_start_dt_check => TRUE,
        )->[0]{Contract}, $expected_contract_with_all_collaterals, 'contract with all collaterals';
    }
);
