#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use qbit;

use Test::Differences;
use Test::More;

use Test::Partner::Utils;
use Test::Partner2::Mock qw(mock_subs restore_subs);
use Test::Partner2::Simple;
use Exception::API::YaMoney;

run_tests(
    sub {
        my ($app) = @_;
        delete $ENV{TAP_VERSION};

        mock_curdate('2018-02-10 15:00:00');
        my @data;
        mock_subs(
            {
                'Application::Model::API::Yandex::SelfService::logbroker' => sub {
                    my ($self, %opts) = @_;
                    # там адреса переменных
                    delete @{$opts{data}[0]}{qw(additional host stack file)};
                    for my $f (@{$opts{data}[0]{parsed_stacktrace}}) {
                        $f->{filename} =~ s|^\./\|.*/(?=t_lib)||;
                    }
                    push @data, \%opts;
                },
                'Sentry::Raven::capture_exception' => sub {
                    return 31415926;
                },
            }
        );

        $app->sentry->send_exception(
            Exception::API::YaMoney->new(
                'Yandex.Money server is saying that it is broken.',
                sentry => {fingerprint => ['YaMoney', 'Server broken']}
            )
        );

        for (@data) {
            for (@{$_->{data} // []}) {
                for (@{$_->{parsed_stacktrace}}) {
                    $_->{lineno} = 'xxx' if ($_->{lineno});
                }
            }
        }
        my $expected_data = get_test_data_and_update_if_needed('data.json', \@data);
        eq_or_diff(from_json(to_json(\@data)), $expected_data, 'checks');

        @data = ();

        $app->sentry->send_exception(Exception::API::YaMoney->new('Yandex.Money server is saying that it is broken.',));

        for (@data) {
            for (@{$_->{data} // []}) {
                for (@{$_->{parsed_stacktrace}}) {
                    $_->{lineno} = 'xxx' if ($_->{lineno});
                }
            }
        }
        my $expected_data_wo_fingerprint = get_test_data_and_update_if_needed('data_wo_fingerprint.json', \@data);
        eq_or_diff(from_json(to_json(\@data)), $expected_data_wo_fingerprint, 'checks');
    },
    dont_create_database => 1,
    init                 => [qw(sentry api_selfservice)],
    locale               => 'C',
);
