#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use qbit;

use Test::Differences;
use Test::More tests => 2;

use Test::Partner::Utils qw(get_test_data_and_update_if_needed);
use Test::Partner2::Mock qw(mock_subs restore_subs);
use Test::Partner2::Simple;
use Exception;
use Exception::CommonOffer;
run_tests(
    sub {
        my ($app) = @_;
        delete $ENV{TAP_VERSION};
        my %data;
        my $test;
        mock_subs(
            {
                'Application::Model::ErrorBooster::convert_and_send' => sub {
                    $test->{errorbooster} = TRUE;
                },
                'Application::Model::ExceptionDumper::build_file' => sub {
                    $test->{dump} = TRUE;
                },
            }
        );
        foreach my $stage (qw(dev test production)) {
            $app->set_option('stage', $stage);
            foreach my $sentry_err (FALSE) {
                mock_subs(
                    {
                        'Sentry::Raven::capture_exception' => sub {
                            $test->{capture} = TRUE;

                            return $sentry_err ? 0 : 31415926;
                        },
                    }
                );
                foreach my $exception_type (qw(Exception Exception::CommonOffer)) {
                    my $key = join('__', $stage, $exception_type, ($sentry_err ? 'sentry_error' : 'no_sentry_err'));
                    $key =~ s/::/_/g;
                    $test = $data{$key} = {
                        capture      => undef,
                        dump         => undef,
                        errorbooster => undef,
                    };
                    my $exception = new $exception_type 'test';
                    $app->exception_dumper->dump_as_html_file($exception);
                }
                restore_subs(['Sentry::Raven::capture_exception']);
            }
        }
        restore_subs(['Application::Model::ExceptionDumper::build_file']);
        my $expected_data = get_test_data_and_update_if_needed('data.json', \%data);
        eq_or_diff(\%data, $expected_data, 'checks');
    },
    dont_create_database => 1,
    init                 => [qw(exception_dumper sentry errorbooster)],
    locale               => 'C',
);
