#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Deep;
use Test::Partner::Utils;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        $app->excluded_domains->replace(1, ['google.com', 'mail.ru',], 'add');

        cmp_deeply(
            $app->excluded_domains->get_all(),
            [{page_id => 1, domain => 'google.com'}, {page_id => 1, domain => 'mail.ru'},],
            'domains saved'
        );

        $app->excluded_domains->replace(1, ['yandex.ru',], 'edit');

        cmp_deeply($app->excluded_domains->get_all(), [{page_id => 1, domain => 'yandex.ru'}], 'domains updated');

        $app->excluded_domains->replace(1, [], 'edit');

        cmp_deeply($app->excluded_domains->get_all(), [], 'domains deleted');
    },
    fill_databases => FALSE,
);
