#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Deep;
use Test::Partner::Utils;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        $app->excluded_phones->replace(1, ['+7 (960) 325 23 74', '8(960)325-23-74',], 'add');

        cmp_deeply(
            $app->excluded_phones->get_all(),
            [{page_id => 1, phone => '+7 (960) 325 23 74'}, {page_id => 1, phone => '8 (960) 325-23-74'},],
            'phones saved'
        );

        $app->excluded_phones->replace(1, ['8(960)3252374',], 'edit');

        cmp_deeply($app->excluded_phones->get_all(), [{page_id => 1, phone => '8 (960) 3252374'}], 'phones updated');

        $app->excluded_phones->replace(1, [], 'edit');

        cmp_deeply($app->excluded_phones->get_all(), [], 'phones deleted');
    },
    fill_databases => FALSE,
);
