#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Deep;
use Test::Partner::Utils;

use qbit;

# TODO: перенести тест в общий модуль Block.pm
run_tests(
    sub {
        my ($app) = @_;

        my $data = [

            # РЕКЛАМА НА САЙТАХ
            {
                accessor => 'context_on_site_rtb',
                fields   => [['id', 'campaign_id'], 'campaign_id'],
                filter   => ['multistate', '=', 'not deleted'],
            },
            {
                accessor => 'context_on_site_direct',
                fields   => [['id', 'campaign_id'], 'campaign_id'],
                filter   => ['multistate', '=', 'not deleted'],
            },
            {
                accessor => 'context_on_site_stripe',
                fields   => [['id', 'campaign_id'], 'campaign_id'],
                filter   => ['multistate', '=', 'not deleted'],
            },
            {
                accessor => 'context_on_site_adblock',
                fields   => [['id', 'page_id'], 'page_id'],
                filter   => ['multistate', '=', 'not deleted'],
            },
            {
                accessor => 'search_on_site_premium',
                fields   => [['id', 'campaign_id'], 'campaign_id'],
                filter   => ['multistate', '=', 'not deleted'],
            },
            {
                accessor => 'search_on_site_direct',
                fields   => [['id', 'campaign_id'], 'campaign_id'],
                filter   => ['multistate', '=', 'not deleted'],
            },

            # РЕКЛАМА В ПРИЛОЖЕНИЯХ
            {
                accessor => 'mobile_app_rtb',
                fields   => [['id', 'campaign_id'], 'campaign_id'],
                filter   => ['multistate', '=', 'not deleted'],
            },

            # РЕКЛАМА В ВИДЕО
            {
                accessor => 'video_an_site_inpage',
                fields   => [['id', 'page_id'], 'page_id'],
                filter   => ['multistate', '=', 'not deleted'],
            },
            {
                accessor => 'video_an_site_instream',
                fields   => [['id', 'page_id'], 'page_id'],
                filter   => ['multistate', '=', 'not deleted'],
            },

            # СЕРВИСЫ ЯНДЕКСА
            {
                accessor => 'internal_context_on_site_rtb',
                fields   => [['id', 'campaign_id'], 'campaign_id'],
                filter   => ['multistate', '=', 'not deleted'],
            },
            {
                accessor => 'internal_context_on_site_direct',
                fields   => [['id', 'campaign_id'], 'campaign_id'],
                filter   => ['multistate', '=', 'not deleted'],
            },
            {
                accessor => 'internal_context_on_site_stripe',
                fields   => [['id', 'campaign_id'], 'campaign_id'],
                filter   => ['multistate', '=', 'not deleted'],
            },

            {
                accessor => 'internal_search_on_site_premium',
                fields   => [['id', 'campaign_id'], 'campaign_id'],
                filter   => ['multistate', '=', 'not deleted'],
            },
            {
                accessor => 'internal_search_on_site_direct',
                fields   => [['id', 'campaign_id'], 'campaign_id'],
                filter   => ['multistate', '=', 'not deleted'],
            },

            {
                accessor => 'internal_mobile_app_rtb',
                fields   => [['id', 'campaign_id'], 'campaign_id'],
                filter   => ['multistate', '=', 'not deleted'],
            },

            # РЕКЛАМНЫЕ ПЛАТФОРМЫ
            {
                accessor => 'dsp',
                fields   => ['id'],
                filter   => ['multistate', '=', 'not deleted'],
            },

            # OLD
            {
                accessor => 'context_on_site_market',
                fields   => [['id', 'campaign_id'], 'campaign_id'],
                filter   => ['multistate', '=', 'not deleted'],
            },
            {
                accessor => 'context_on_site_mcb',
                fields   => [['id', 'campaign_id'], 'campaign_id'],
                filter   => ['multistate', '=', 'not deleted'],
            },
            {
                accessor => 'search_on_site_market',
                fields   => [['id', 'campaign_id'], 'campaign_id'],
                filter   => ['multistate', '=', 'not deleted'],
            },
            {
                accessor => 'search_on_site_mcb',
                fields   => [['id', 'campaign_id'], 'campaign_id'],
                filter   => ['multistate', '=', 'not deleted'],
            },

            # Devel
            {
                accessor => 'mailer',
                fields   => ['id'],
                filter   => ['dt', '=', '2016-10-01'],
                rights   => [qw( mailer_view users_view_all )]
            },
        ];

        foreach my $row (@$data) {
            my ($accessor, $fields, $filter, $rights) = @$row{qw( accessor  fields  filter  rights )};

            my $tmp_rights = undef;
            if ($rights && @$rights) {
                $tmp_rights = $app->add_tmp_rights(@$rights);
            }

            my $got = $app->$accessor->get_fields_cnt(
                fields => $fields,
                filter => $filter,
            );

            cmp_deeply($got, all(isa('HASH'), superhashof({cnt_id => re(qr/^\d+$/)}),), $accessor);
        }

    },
    reuse_database => 1
);
