#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Deep;
use Test::Partner::Utils;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        $app->filters->replace(1, [1], 'add');

        cmp_deeply($app->filters->get_all(filter => {page_id => 1}), [{page_id => 1, filter_id => 1},],
            'filters saved');

        $app->filters->replace(1, [], 'edit');

        cmp_deeply($app->filters->get_all(filter => {page_id => 1}), [], 'filters deleted');
    },
);
