#!/usr/bin/perl -w

use Test::More;
use Test::Deep;

use qbit;

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs);

run_tests(
    sub {
        my ($app) = @_;

        mock_app($app);
        insert_blocks_to_all_blocks($app);

        change_cur_user($app, 'mocked-yan-partner');

        cmp_deeply(
            [$app->frontend->find_blocks()],
            [
                {
                    'caption'   => 'First Direct block',
                    'id'        => '3',
                    'model'     => 'search_on_site_direct',
                    'page_id'   => '41443',
                    'public_id' => 'D-A-41443-3'
                },
                {
                    'caption'   => 'First RTB block',
                    'id'        => '1',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '41443',
                    'public_id' => 'R-A-41443-1'
                },
                {
                    'caption'   => 'First RTB block',
                    'id'        => '12',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '41443',
                    'public_id' => 'R-A-41443-12'
                },
                {
                    'caption'   => 'First RTB block (another page)',
                    'id'        => '1',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '142898',
                    'public_id' => 'R-A-142898-1'
                },
                {
                    'caption'   => 'page 41443-like block',
                    'id'        => '2',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '142898',
                    'public_id' => 'R-A-142898-2'
                },
                {
                    'caption'   => 'Second RTB block',
                    'id'        => '2',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '41443',
                    'public_id' => 'R-A-41443-2'
                },
            ],
            'mocked-yan-partner, text = ""'
        );

        cmp_deeply(
            [$app->frontend->find_blocks('First')],
            [
                {
                    'caption'   => 'First Direct block',
                    'id'        => '3',
                    'model'     => 'search_on_site_direct',
                    'page_id'   => '41443',
                    'public_id' => 'D-A-41443-3'
                },
                {
                    'caption'   => 'First RTB block',
                    'id'        => '1',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '41443',
                    'public_id' => 'R-A-41443-1'
                },
                {
                    'caption'   => 'First RTB block',
                    'id'        => '12',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '41443',
                    'public_id' => 'R-A-41443-12'
                },
                {
                    'caption'   => 'First RTB block (another page)',
                    'id'        => '1',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '142898',
                    'public_id' => 'R-A-142898-1'
                }
            ],
            'mocked-yan-partner, text = "First"'
        );

        cmp_deeply(
            [$app->frontend->find_blocks('RTB block')],
            [
                {
                    'caption'   => 'First RTB block',
                    'id'        => '1',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '41443',
                    'public_id' => 'R-A-41443-1'
                },
                {
                    'caption'   => 'First RTB block',
                    'id'        => '12',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '41443',
                    'public_id' => 'R-A-41443-12'
                },
                {
                    'caption'   => 'First RTB block (another page)',
                    'id'        => '1',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '142898',
                    'public_id' => 'R-A-142898-1'
                },
                {
                    'caption'   => 'Second RTB block',
                    'id'        => '2',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '41443',
                    'public_id' => 'R-A-41443-2'
                }
            ],
            'mocked-yan-partner, text = "RTB block"'
        );

        cmp_deeply(
            [$app->frontend->find_blocks('R')],
            [
                {
                    'caption'   => 'First Direct block',
                    'id'        => '3',
                    'model'     => 'search_on_site_direct',
                    'page_id'   => '41443',
                    'public_id' => 'D-A-41443-3'
                },
                {
                    'caption'   => 'First RTB block',
                    'id'        => '1',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '41443',
                    'public_id' => 'R-A-41443-1'
                },
                {
                    'caption'   => 'First RTB block',
                    'id'        => '12',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '41443',
                    'public_id' => 'R-A-41443-12'
                },
                {
                    'caption'   => 'First RTB block (another page)',
                    'id'        => '1',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '142898',
                    'public_id' => 'R-A-142898-1'
                },
                {
                    'caption'   => 'Second RTB block',
                    'id'        => '2',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '41443',
                    'public_id' => 'R-A-41443-2'
                }
            ],
            'mocked-yan-partner, text = "R"'
        );

        cmp_deeply(
            [$app->frontend->find_blocks('R-A')],
            [
                {
                    'caption'   => 'First RTB block',
                    'id'        => '1',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '41443',
                    'public_id' => 'R-A-41443-1'
                },
                {
                    'caption'   => 'Second RTB block',
                    'id'        => '2',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '41443',
                    'public_id' => 'R-A-41443-2'
                },
                {
                    'caption'   => 'First RTB block',
                    'id'        => '12',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '41443',
                    'public_id' => 'R-A-41443-12'
                },
                {
                    'caption'   => 'First RTB block (another page)',
                    'id'        => '1',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '142898',
                    'public_id' => 'R-A-142898-1'
                },
                {
                    'caption'   => 'page 41443-like block',
                    'id'        => '2',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '142898',
                    'public_id' => 'R-A-142898-2'
                },
            ],
            'mocked-yan-partner, text = "R-A"'
        );

        cmp_deeply(
            [$app->frontend->find_blocks('R-A-')],
            [
                {
                    'caption'   => 'First RTB block',
                    'id'        => '1',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '41443',
                    'public_id' => 'R-A-41443-1'
                },
                {
                    'caption'   => 'Second RTB block',
                    'id'        => '2',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '41443',
                    'public_id' => 'R-A-41443-2'
                },
                {
                    'caption'   => 'First RTB block',
                    'id'        => '12',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '41443',
                    'public_id' => 'R-A-41443-12'
                },
                {
                    'caption'   => 'First RTB block (another page)',
                    'id'        => '1',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '142898',
                    'public_id' => 'R-A-142898-1'
                },
                {
                    'caption'   => 'page 41443-like block',
                    'id'        => '2',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '142898',
                    'public_id' => 'R-A-142898-2'
                },
            ],
            'mocked-yan-partner, text = "R-A-"'
        );

        cmp_deeply(
            [$app->frontend->find_blocks('R-A-1428')],
            [
                {
                    'caption'   => 'First RTB block (another page)',
                    'id'        => '1',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '142898',
                    'public_id' => 'R-A-142898-1'
                },
                {
                    'caption'   => 'page 41443-like block',
                    'id'        => '2',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '142898',
                    'public_id' => 'R-A-142898-2'
                },
            ],
            'mocked-yan-partner, text = "R-A-1428"'
        );

        cmp_deeply(
            [$app->frontend->find_blocks('D-A-')],
            [
                {
                    'caption'   => 'First Direct block',
                    'id'        => '3',
                    'model'     => 'search_on_site_direct',
                    'page_id'   => '41443',
                    'public_id' => 'D-A-41443-3'
                }
            ],
            'mocked-yan-partner, text = "D-A-"'
        );

        cmp_deeply(
            [$app->frontend->find_blocks('R-A-41443')],
            [
                {
                    'caption'   => 'First RTB block',
                    'id'        => '1',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '41443',
                    'public_id' => 'R-A-41443-1'
                },
                {
                    'caption'   => 'Second RTB block',
                    'id'        => '2',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '41443',
                    'public_id' => 'R-A-41443-2'
                },
                {
                    'caption'   => 'First RTB block',
                    'id'        => '12',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '41443',
                    'public_id' => 'R-A-41443-12'
                },
                {
                    'caption'   => 'page 41443-like block',
                    'id'        => '2',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '142898',
                    'public_id' => 'R-A-142898-2'
                },
            ],
            'mocked-yan-partner, text = "R-A-41443"'
        );

        cmp_deeply(
            [$app->frontend->find_blocks('R-A-41443-')],
            [
                {
                    'caption'   => 'First RTB block',
                    'id'        => '1',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '41443',
                    'public_id' => 'R-A-41443-1'
                },
                {
                    'caption'   => 'Second RTB block',
                    'id'        => '2',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '41443',
                    'public_id' => 'R-A-41443-2'
                },
                {
                    'caption'   => 'First RTB block',
                    'id'        => '12',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '41443',
                    'public_id' => 'R-A-41443-12'
                }
            ],
            'mocked-yan-partner, text = "R-A-41443-"'
        );

        cmp_deeply(
            [$app->frontend->find_blocks('R-A-41443-1')],
            [
                {
                    'caption'   => 'First RTB block',
                    'id'        => '1',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '41443',
                    'public_id' => 'R-A-41443-1'
                },
                {
                    'caption'   => 'First RTB block',
                    'id'        => '12',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '41443',
                    'public_id' => 'R-A-41443-12'
                },
            ],
            'mocked-yan-partner, text = "R-A-41443-1"'
        );

        cmp_deeply(
            [$app->frontend->find_blocks('1428')],
            [
                {
                    'caption'   => 'First RTB block (another page)',
                    'id'        => '1',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '142898',
                    'public_id' => 'R-A-142898-1'
                },
                {
                    'caption'   => 'page 41443-like block',
                    'id'        => '2',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '142898',
                    'public_id' => 'R-A-142898-2'
                },
            ],
            'mocked-yan-partner, text = "1428"'
        );

        cmp_deeply(
            [$app->frontend->find_blocks('41443')],
            [
                {
                    'caption'   => 'First RTB block',
                    'id'        => '1',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '41443',
                    'public_id' => 'R-A-41443-1'
                },
                {
                    'caption'   => 'Second RTB block',
                    'id'        => '2',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '41443',
                    'public_id' => 'R-A-41443-2'
                },
                {
                    'caption'   => 'First Direct block',
                    'id'        => '3',
                    'model'     => 'search_on_site_direct',
                    'page_id'   => '41443',
                    'public_id' => 'D-A-41443-3'
                },
                {
                    'caption'   => 'First RTB block',
                    'id'        => '12',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '41443',
                    'public_id' => 'R-A-41443-12'
                },
                {
                    'caption'   => 'page 41443-like block',
                    'id'        => '2',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '142898',
                    'public_id' => 'R-A-142898-2'
                },
            ],
            'mocked-yan-partner, text = "41443"'
        );

        cmp_deeply(
            [$app->frontend->find_blocks('142898')],
            [
                {
                    'caption'   => 'First RTB block (another page)',
                    'id'        => '1',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '142898',
                    'public_id' => 'R-A-142898-1'
                },
                {
                    'caption'   => 'page 41443-like block',
                    'id'        => '2',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '142898',
                    'public_id' => 'R-A-142898-2'
                },
            ],
            'mocked-yan-partner, text = "142898"'
        );

        cmp_deeply(
            [$app->frontend->find_blocks('142898-1')],
            [
                {
                    'caption'   => 'First RTB block (another page)',
                    'id'        => '1',
                    'model'     => 'context_on_site_rtb',
                    'page_id'   => '142898',
                    'public_id' => 'R-A-142898-1'
                }
            ],
            'mocked-yan-partner, text = "142898-1"'
        );

        cmp_deeply(
            [$app->frontend->find_blocks('r-a-')],
            [$app->frontend->find_blocks('R-A-')],
            'mocked-yan-partner, result is equal for "r-a-" and "R-A-" substring'
        );
    },
    init => ['statistics'],
);

sub mock_app {
    mock_subs({'Application::Model::Statistics::Product::is_available' => sub {TRUE},});
}

sub insert_blocks_to_all_blocks {
    my ($app) = @_;

    $app->partner_db->all_blocks->add_multi(
        [
            {
                page_id => 41443,
                id      => 1,
                model   => 'context_on_site_rtb',
                caption => 'First RTB block'
            },
            {
                page_id => 41443,
                id      => 2,
                model   => 'context_on_site_rtb',
                caption => 'Second RTB block'
            },
            {
                page_id => 41443,
                id      => 12,
                model   => 'context_on_site_rtb',
                caption => 'First RTB block'
            },
            {
                page_id => 142898,
                id      => 1,
                model   => 'context_on_site_rtb',
                caption => 'First RTB block (another page)'
            },
            {
                page_id => 471738,
                id      => 1,
                model   => 'context_on_site_rtb',
                caption => 'First RTB block (no access)'
            },
            {
                page_id => 41443,
                id      => 3,
                model   => 'search_on_site_direct',
                caption => 'First Direct block'
            },
            {
                page_id => 43569,
                id      => 1,
                model   => 'mobile_app_rtb',
                caption => 'First Mobile RTB block (no access)'
            },
            {
                page_id => 142898,
                id      => 2,
                model   => 'context_on_site_rtb',
                caption => 'page 41443-like block'
            },
        ]
    );
}
