#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;

$ENV{LAZY_LOAD} = 0;

run_tests(
    sub {
        my ($app) = @_;

        cmp_deeply(
            $app->frontend->find_resource(name => 'login', value => 'yndx-blizzard'),
            {'resource' => 'users'},
            'name => login, value => yndx-blizzard'
        );

        cmp_deeply(
            $app->frontend->find_resource(name => 'page_id', value => 41443),
            {'resource' => 'context_on_site_campaign'},
            'name => page_id, value => 41443'
        );

        cmp_deeply(
            $app->frontend->find_resource(name => 'context_page_id', value => 43569),
            {'resource' => 'mobile_app_settings'},
            'name => context_page_id, value => 43569'
        );

        cmp_deeply(
            $app->frontend->find_resource(name => 'application_id', value => 132439),
            {'resource' => 'internal_mobile_app'},
            'name => application_id, value => 132439'
        );

        cmp_deeply(
            $app->frontend->find_resource(name => 'public_id', value => 'R-A-41443-1'),
            {'resource' => 'context_on_site_rtb', 'public_id' => 'R-A-41443-1'},
            'name => public_id, value => R-A-41443-1'
        );

        # Direct -> RTB  (#PI-10318)
        cmp_deeply(
            $app->frontend->find_resource(name => 'public_id', value => 'D-A-41443-1', relaxed => 1),
            {'resource' => 'context_on_site_rtb', 'public_id' => 'R-A-41443-1'},
            'name => public_id, value => R-A-41443-1 (relaxed)'
        );

        cmp_deeply(
            $app->frontend->find_resource(name => 'dsp_id', value => '2563117'),
            {'resource' => 'dsp'},
            'name => dsp_id, value => 2563117'
        );

        cmp_deeply(
            $app->frontend->find_resource(name => 'tag_id', value => '123'),
            {'resource' => 'block_tags'},
            'name => tag_id, value => 123'
        );

    },
    application_package => 'Rosetta',
);
