#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use Encode;
use Test::Deep;
use Test::Partner2::Simple;

my $test_opts = {
    application_package => 'Rosetta',
    user                => 'mocked-yan-partner',
    db_suites           => {partner_db => [qw( users )],},
    locale              => 'en',
};

run_tests(
    sub {
        my ($app) = @_;

        my $got = $app->frontend->get_locales();

        my $expect = {
            en => 'English',
            ru => decode_utf8('Русский'),
        };

        cmp_deeply($got, $expect, 'Correct initial database state');

    },
    %$test_opts
);
