#!/usr/bin/perl -w

use qbit;
use Test::Partner2::Simple;

use Test::Deep qw(cmp_deeply ignore re );

no strict 'refs';
no warnings 'redefine';

run_tests(
    sub {
        my ($app) = @_;

        *{'Application::Model::PartnerDB::all_pages'} = sub {$app->partner_db->all_pages_view};

        my $geo_base = $app->geo_base->get_geobase(user_id => 1009);

        cmp_deeply(
            [grep {$_->{'id'} == 977} @$geo_base],
            [
                {
                    'regularity' => '0',
                    'level'      => '2',
                    'name'       => re(qr(\w)),
                    'id'         => '977',
                    'parent_id'  => 26
                },
            ],
            'get_geobase for RUS partner'
        );

        my @tree = $app->geo_base->get_tree_with_cpm(41443, [{id => 225, cpm => 55}]);

        cmp_deeply(
            [sort {$a->{id} cmp $b->{id}} @tree],
            [
                sort {$a->{id} cmp $b->{id}} (
                    {
                        'id'  => '10645',
                        'cpm' => 55
                    },
                    {
                        'id'  => '225',
                        'cpm' => 55
                    },
                    {
                        'id'  => '3',
                        'cpm' => 55
                    },
                    {
                        'id'  => '213',
                        'cpm' => 55
                    },
                    {
                        'id'  => '26',
                        'cpm' => 55
                    },
                    {
                        'id'  => '2',
                        'cpm' => 55
                    },
                    {
                        'id'  => '17',
                        'cpm' => 55
                    },
                    {
                        'id'  => '977',
                        'cpm' => 55
                    },
                    {
                        'id'  => '1',
                        'cpm' => 55
                    },
                    {
                        'id'  => '10174',
                        'cpm' => 55
                    },
                    {
                        'id'  => '10650',
                        'cpm' => 55
                    },
                )
            ],
            'get_tree_with_cpm for RUS partner with 1 cpm'
        );

        @tree = $app->geo_base->get_tree_with_cpm(41443, [{id => 225, cpm => 55}, {id => 1, cpm => 60}]);

        cmp_deeply(
            [sort {$a->{id} cmp $b->{id}} @tree],
            [
                sort {$a->{id} cmp $b->{id}} (
                    {
                        'id'  => '10645',
                        'cpm' => 55
                    },
                    {
                        'id'  => '225',
                        'cpm' => 55
                    },
                    {
                        'id'  => '3',
                        'cpm' => 55
                    },
                    {
                        'id'  => '213',
                        'cpm' => 60
                    },
                    {
                        'id'  => '26',
                        'cpm' => 55
                    },
                    {
                        'id'  => '2',
                        'cpm' => 55
                    },
                    {
                        'id'  => '17',
                        'cpm' => 55
                    },
                    {
                        'id'  => '977',
                        'cpm' => 55
                    },
                    {
                        'id'  => '10174',
                        'cpm' => 55
                    },
                    {
                        'id'  => '1',
                        'cpm' => 60
                    },
                    {
                        'id'  => '10650',
                        'cpm' => 55
                    },
                )
            ],
            'get_tree_with_cpm for RUS partner with 2 cpm'
        );

        $app->partner_db->users->edit(1009, {country_id => 187});

        no warnings 'once';
        %Application::Model::GeoBase::GEOBASE_CACHE = ();

        $geo_base = $app->geo_base->get_geobase(user_id => 1009);

        cmp_deeply(
            [grep {$_->{'id'} == 977} @$geo_base],
            [
                {
                    'regularity' => '0',
                    'level'      => '3',
                    'name'       => re(qr(\w)),
                    'id'         => '977',
                    'parent_id'  => 20526
                },
            ],
            'get_geobase for UK partner'
        );

        @tree = $app->geo_base->get_tree_with_cpm(41443, [{id => 166, cpm => 45}]);

        cmp_deeply(
            [sort {$a->{id} cmp $b->{id}} @tree],
            [
                sort {$a->{id} cmp $b->{id}} (
                    {
                        'id'  => '20529',
                        'cpm' => 45
                    },
                    {
                        'id'  => '149',
                        'cpm' => 45
                    },
                    {
                        'id'  => '20524',
                        'cpm' => 45
                    },
                    {
                        'id'  => '29630',
                        'cpm' => 45
                    },
                    {
                        'id'  => '20526',
                        'cpm' => 45
                    },
                    {
                        'id'  => '977',
                        'cpm' => 45
                    },
                    {
                        'id'  => '20530',
                        'cpm' => 45
                    },
                    {
                        'id'  => '166',
                        'cpm' => 45
                    },
                    {
                        'id'  => '29629',
                        'cpm' => 45
                    },
                    {
                        'id'  => '187',
                        'cpm' => 45
                    },
                )
            ],
            'get_tree_with_cpm for UK partner with 1 cpm'
        );

        @tree = $app->geo_base->get_tree_with_cpm(41443, [{id => 166, cpm => 45}, {id => 20524, cpm => 20}]);

        cmp_deeply(
            [sort {$a->{id} cmp $b->{id}} @tree],
            [
                sort {$a->{id} cmp $b->{id}} (
                    {
                        'id'  => '20529',
                        'cpm' => 20
                    },
                    {
                        'id'  => '149',
                        'cpm' => 45
                    },
                    {
                        'id'  => '20524',
                        'cpm' => 20
                    },
                    {
                        'id'  => '29630',
                        'cpm' => 45
                    },
                    {
                        'id'  => '20526',
                        'cpm' => 45
                    },
                    {
                        'id'  => '977',
                        'cpm' => 45
                    },
                    {
                        'id'  => '20530',
                        'cpm' => 20
                    },
                    {
                        'id'  => '166',
                        'cpm' => 45
                    },
                    {
                        'id'  => '29629',
                        'cpm' => 45
                    },
                    {
                        'id'  => '187',
                        'cpm' => 45
                    }
                )
            ],
            'get_tree_with_cpm for UK partner with 2 cpm'
        );
    }
);
