use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;

sub check_host {
    my ($app) = @_;

    my @result = $app->intapi_acl->acl2subnets('192.168.1.1',);

    is_deeply(\@result, ['192.168.1.1/32'], 'check host',);

    return 1;
}

sub check_subnet {
    my ($app) = @_;

    my @result = $app->intapi_acl->acl2subnets('5.255.210.64/28',);

    is_deeply(\@result, ['5.255.210.64/28'], 'check subnet',);

    return 1;
}

run_tests(
    sub {
        my ($app) = @_;

        check_host($app);
        check_subnet($app);
    },
);
