use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::MockObject::Extends::Easy;

use Test::More;

sub get_intapi_acl_for_element {
    my ($app, $path, $method) = @_;

    my $intapi_acl;
    foreach my $el (@{$app->intapi_acl->get_all(with_acl => 1)}) {
        if (($el->{path} eq $path) && ($el->{method} eq $method)) {
            $intapi_acl = $el;
            last;
        }
    }

    if (!$intapi_acl) {
        die "Can't find info about $path/$method";
    }

    return $intapi_acl;
}

run_tests(
    sub {
        my ($app) = @_;

        my ($testPath, $testMethod) = qw/idm info/;

        $app->api_hbf;
        $app->{'api_hbf'} = Test::MockObject::Extends->new($app->{'api_hbf'});
        $app->{'api_hbf'}->mock(
            'get_hosts_from_macros',
            sub {
                my ($self, $acl) = @_;

                $acl =~ s/_C_PARTNER_RTB_FRONTENDS_PROD_/127.0.0.1/;

                return split(' ', $acl);
            }
        );

        my $intapi_acl = get_intapi_acl_for_element($app, $testPath, $testMethod);
        ok(!defined($intapi_acl->{'acl'}), 'At first thre is no ACL');

        $app->intapi_acl->set_acl($testPath, $testMethod, '_C_PARTNER_RTB_FRONTENDS_PROD_');

        $intapi_acl = get_intapi_acl_for_element($app, $testPath, $testMethod);
        is($intapi_acl->{'acl'}, '_C_PARTNER_RTB_FRONTENDS_PROD_', 'There is ACL after setting it');

        $app->intapi_acl->set_acl($testPath, $testMethod, '_C_PARTNER_RTB_FRONTENDS_PROD_ 5.255.228.81');

        $intapi_acl = get_intapi_acl_for_element($app, $testPath, $testMethod);
        is($intapi_acl->{'acl'}, '_C_PARTNER_RTB_FRONTENDS_PROD_ 5.255.228.81', 'ACL is changed after changing');

        is(
            $app->partner_db->intapi_acl->get([$testPath, $testMethod], fields => ['acl_cached'])->{'acl_cached'},
            '["5.255.228.81/32","127.0.0.1/32"]',
            'check acl_cached'
          );
    },
);
