#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use Test::More;
use Test::Partner2::Simple;
use Test::Partner2::Mock;
use Test::Differences;
use Test::Exception;
use Test::Partner2::Fixture;

use qbit;

my $INVITATION_ID = 1;

my %COMMON = (
    email => 'to@yandex.ru',
    lang  => 'ru',
    type  => 7,
);

my $CURDATE = '2022-04-22 09:00:00';

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate($CURDATE);

        mock_mailer($app);
        mock_text_template($app);
        change_cur_user($app, 'mocked-yan-partner');

        restore_subs([qw(Application::Model::Inviter::_generate_id)]);
        mock_subs(
            {
                'Application::Model::Inviter::_generate_id' => sub {++$INVITATION_ID}
            }
        );

        my $context_page_id = get_fixture('partner_context_page')->{page_id};
        my $mobile_page_id  = get_fixture('partner_mobile_page')->{context_page_id};

        my $invite_id = $app->inviter->add(%COMMON);
        is($invite_id, $INVITATION_ID, 'invite created');

        throws_ok {
            $app->inviter->add(%COMMON, page_id => 'page_id',);
        }
        'Exception::Validator::Errors', "Incorrect Page ID";

        throws_ok {
            $app->inviter->add(%COMMON, page_id => 0,);
        }
        'Exception::Validator::Errors', "Page not found for page_id";

        throws_ok {
            $app->inviter->add(%COMMON, page_id => $context_page_id,);
        }
        'Exception::Validator::Errors', "You can not add invite for this page";

        lives_ok {
            $app->inviter->add(
                %COMMON,
                email   => 'common@yandex.ru',
                page_id => $mobile_page_id,
            );
        }
        'You can add invite only for mobile page';

        my $inviter_id = $app->inviter->add(
            %COMMON,
            email   => 'common@yandex.ru',
            page_id => $mobile_page_id,
        );

        my $invites = $app->inviter->get_all(
            fields => [qw(update_time)],
            filter => {email => 'common@yandex.ru'},
        )->[0];
        eq_or_diff($invites->{update_time}, $CURDATE, 'update_time updated when email is common');

        my $assistants = $app->assistants->get_assistants();

        eq_or_diff(
            $assistants,
            [
                {
                    can_edit   => 0,
                    email      => 'common@yandex.ru',
                    expired    => '',
                    page_id    => $mobile_page_id,
                    user_id    => 0,
                    inviter_id => $INVITATION_ID,
                    login      => undef,
                }
            ],
            'get_assistants'
        );
    },
    fixtures       => ['partner_context_page', 'partner_mobile_page', 'user_cron'],
    fill_databases => 0,
);
