#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use qbit;

use Test::More;
use Test::Partner2::Simple;

my $test_opts = {
    application_package => 'Rosetta',
    db_suites           => {partner_db => [qw( users )],}
};

run_tests(
    sub {
        my ($app) = @_;

        subtest 'get_types for "yndx-developer" EN locale' => sub {
            $app->set_app_locale('en');
            _do_check(
                \&check_get_types,
                $app,
                'yndx-developer',
                [
                    {
                        id    => 1,
                        label => gettext('Advertising network: Sites')
                    },
                    {
                        id    => 3,
                        label => gettext('DSP')
                    },
                    {
                        id    => 5,
                        label => gettext('Video advertising network')
                    },
                    {
                        id    => 6,
                        label => gettext('Advertising network: Applications')
                    },
                    {
                        id    => 7,
                        label => gettext('Advertising network: Partner\'s assistant')
                    }
                ]
            );
        };

        subtest 'get_types for "mocked-yan-manager" RU locale' => sub {
            $app->set_app_locale('ru');
            _do_check(
                \&check_get_types,
                $app,
                'mocked-yan-manager',
                [
                    {
                        id    => 1,
                        label => gettext('Advertising network: Sites')
                    },
                    {
                        id    => 5,
                        label => gettext('Video advertising network')
                    },
                    {
                        id    => 6,
                        label => gettext('Advertising network: Applications')
                    },
                    {
                        id    => 7,
                        label => gettext('Advertising network: Partner\'s assistant')
                    }
                ]
            );
        };

    },
    %$test_opts
);

sub check_get_types {
    my ($app, $user_login, $expect) = @_;

    my $got = $app->inviter->get_types();
    is_deeply($got, $expect, 'Types is correct');
}

sub _do_check {
    my ($sub_ref, $app, $user_login, @args) = @_;

    # set new user if it changed
    change_cur_user($app, $user_login);

    ####### Check
    my $res = $sub_ref->($app, $user_login, @args);

    return $res;
}
