#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use Test::More;
use Test::Partner2::Simple;
use Test::Partner2::Mock;
use Test::Differences;

use qbit;

my $INVITATION_ID = 1;

run_tests(
    sub {
        my ($app) = @_;

        mock_mailer($app);
        mock_text_template($app);
        change_cur_user($app, 'mocked-yan-partner');

        restore_subs([qw(Application::Model::Inviter::_generate_id)]);
        mock_subs(
            {
                'Application::Model::Inviter::_generate_id' => sub {$INVITATION_ID++}
            }
        );

        my $invite_id = $app->inviter->add(
            email => 'to@yandex.ru',
            lang  => 'ru',
            type  => 7,
        );

        my $invite = $app->inviter->get($invite_id, fields => [qw(is_expired create_date)]);

        is($invite->{is_expired}, FALSE, 'is_expired FALSE');
        $app->partner_db->invites->edit(
            $invite_id,
            {
                opts => {
                    json_set => [
                        'opts',
                        \'$.update_time',
                        \date_add(
                            $invite->{create_date},
                            second  => -2592000 - 10,
                            iformat => 'db_time',
                            oformat => 'db_time',
                        )
                    ]
                }
            }
        );

        is($app->inviter->get($invite_id, fields => [qw(is_expired)])->{is_expired}, TRUE, 'is_expired TRUE');
    },
);
