use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;

sub check_moscow_yandex {
    my ($app) = @_;

    # Москва, ул. Льва Толстого ул, 16

    my $code         = 770000000007095;
    my $house_number = 16;
    my $building     = "";
    my $construction = "";
    my $flat         = "";
    my $zipcode      = 119034;

    my $result = $app->kladr->validate_address($code, $house_number, $building, $construction, $flat, $zipcode,);

    is_deeply(
        $result,
        {
            building     => $building,
            code         => $code,
            construction => $construction,
            flat         => $flat,
            gni          => 7704,
            home         => $house_number,
            postcode     => $zipcode,
        },
        'validate_address()',
    );

}

sub check_moscow_yandex_with_other_zipcode {
    my ($app) = @_;

    # Москва, ул. Льва Толстого ул, 16

    my $code         = 770000000007095;
    my $house_number = 16;
    my $building     = "";                # корпус
    my $construction = "";                # строение
    my $flat         = "";
    my $zipcode      = 123456;

    my $result = $app->kladr->validate_address($code, $house_number, $building, $construction, $flat, $zipcode,);

    is_deeply(
        $result,
        {
            building     => $building,
            code         => $code,
            construction => $construction,
            flat         => $flat,
            gni          => 7704,
            home         => $house_number,
            postcode     => "119034",        # validate_address() изменил адерс
        },
        'validate_address()',
    );

}

run_tests(
    sub {
        my ($app) = @_;

        check_moscow_yandex($app);
        check_moscow_yandex_with_other_zipcode($app);
    },
);
