#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use Test::Differences;
use Test::Exception;
use Test::More tests => 2 + 4;

use Test::Partner2::Mock qw( mock_curdate );
use Test::Partner2::Simple;

use Exception::Validation::BadArguments;
use Exception::Validator::Errors;

use qbit;

my $tm     = '2018-09-13 17:00:00';
my %normal = (
    type    => 0,
    user_id => 0,
    period  => undef,
);

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate($tm);
        my $mn = $app->mail_notification;

        my $id;
        throws_ok {$id = $mn->add()} 'Exception::Validator::Errors', 'validation: empty list';
        throws_ok {$id = $mn->add(%normal, extra_field => 1,)} 'Exception::Validation::BadArguments',
          'validation: extra list';
        $id = $mn->add(%normal);
        eq_or_diff($id, 1, 'validation: normal list');
        eq_or_diff(
            $mn->partner_db_table()->get_all(
                fields => [qw(id multistate type user_id period create_date date_x opts)],
                filter => {id => $id},
            ),
            [
                {
                    %normal,
                    create_date => $tm,
                    date_x      => $tm,
                    id          => 1,
                    multistate  => 1,
                    opts        => '{}',
                },
            ],
            'check values in db'
        );
    },
    db_suites => {partner_db => [qw( users mail_notification)],},
);
