#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use Test::Differences;
use Test::Exception;
use Test::More tests => 2 + 2;

use Test::Partner2::Mock qw( mock_curdate );
use Test::Partner2::Simple;

use qbit;

my $id = 0;

run_tests(
    sub {
        my ($app) = @_;

        my $mn = $app->mail_notification;

        eq_or_diff($mn->can_action_periodicity($id), '', 'mailing without periodicity');
        $app->mail_notification->partner_db_table()->edit($id, {period => 300,});
        eq_or_diff($mn->can_action_periodicity($id), 1, 'mailing with periodicity');
    },
    db_suites => {partner_db => [qw( mail_notification)],},
);
