#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use Test::Differences;
use Test::Exception;
use Test::More tests => 2 + 4;

use Test::Partner2::Simple;

use qbit;

my $id = 0;

my $app;
run_tests(
    sub {
        ($app) = @_;

        my $mn = $app->mail_notification;

        subtest 'preparing with type specific check (true)' => sub {
            plan tests => 1;

            $app->mail_notification->partner_db_table()->edit(
                $id,
                {
                    multistate => 1,
                    type       => 5,
                }
            );

            no strict 'refs';
            no warnings 'redefine';

            my $do_action = \&QBit::Application::Model::Multistate::DB::do_action;
            local *{'QBit::Application::Model::Multistate::DB::do_action'} = sub {
                *{'QBit::Application::Model::Multistate::DB::do_action'} = sub {
                    my ($self, $obj, $action) = @_;

                    if ($action eq 'stop') {
                        fail('unexpected action "stop"');
                    } else {
                        fail("unexpected action: $action");
                    }
                };
                goto $do_action;
            };
            $mn->do_action($id, 'prepare');
            _check_values_in_db(multistate => 2, type => 5,);
        };

        subtest 'mailing to blocked user (user without roles)' => sub {
            plan tests => 2;

            $app->mail_notification->partner_db_table()->edit($id, {multistate => 1,});

            my $opts = from_json($app->partner_db->users->get(1009, fields => ['opts'])->{opts});
            $app->partner_db->users->edit(1009, {opts => to_json({is_form_done => 1, %{$opts}})});

            no strict 'refs';
            no warnings 'redefine';

            my $do_action = \&QBit::Application::Model::Multistate::DB::do_action;
            local *{'QBit::Application::Model::Multistate::DB::do_action'} = sub {
                *{'QBit::Application::Model::Multistate::DB::do_action'} = sub {
                    my ($self, $obj, $action) = @_;

                    eq_or_diff($action, 'stop');
                    goto $do_action;
                };
                goto $do_action;
            };
            $mn->do_action($id, 'prepare');
            _check_values_in_db(multistate => 10, type => 5,);
        };

        subtest 'mailing to active user (user with roles)' => sub {
            plan tests => 1;

            $app->mail_notification->partner_db_table()->edit(
                $id,
                {
                    multistate => 1,
                    type       => 0,
                }
            );

            no strict 'refs';
            no warnings 'redefine';

            my $do_action = \&QBit::Application::Model::Multistate::DB::do_action;
            local *{'QBit::Application::Model::Multistate::DB::do_action'} = sub {
                *{'QBit::Application::Model::Multistate::DB::do_action'} = sub {
                    my ($self, $obj, $action) = @_;

                    if ($action eq 'stop') {
                        fail('unexpected action "stop"');
                    } else {
                        fail("unexpected action: $action");
                    }
                };
                goto $do_action;
            };
            $mn->do_action($id, 'prepare');
            _check_values_in_db(multistate => 2);
        };

        subtest 'mailing to blocked user (user without roles)' => sub {
            plan tests => 2;

            $app->mail_notification->partner_db_table()->edit(
                $id,
                {
                    multistate => 1,
                    user_id    => 0,    # у крон-юзера нет ролей = заблокирован
                }
            );

            no strict 'refs';
            no warnings 'redefine';

            my $do_action = \&QBit::Application::Model::Multistate::DB::do_action;
            local *{'QBit::Application::Model::Multistate::DB::do_action'} = sub {
                *{'QBit::Application::Model::Multistate::DB::do_action'} = sub {
                    my ($self, $obj, $action) = @_;

                    eq_or_diff($action, 'stop');
                    goto $do_action;
                };
                goto $do_action;
            };
            $mn->do_action($id, 'prepare');
            _check_values_in_db(multistate => 10, user_id => 0,);
        };
    },
    db_suites => {partner_db => [qw(users mail_notification)],},
);

sub _check_values_in_db {
    eq_or_diff(
        $app->mail_notification->partner_db_table()->get_all(
            fields => [qw(id multistate type user_id period create_date date_x opts)],
            filter => {id => $id},
        ),
        [
            {
                create_date => '2018-09-13 16:30:00',
                date_x      => '2018-09-13 17:00:00',
                id          => $id,
                multistate  => 0,
                opts        => '{}',
                period      => undef,
                type        => 0,
                user_id     => 1009,
                @_,
            },
        ],
        'check values in db'
    );
}
