#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner::Utils qw(get_bk_data);

use DDP;
use Test::More;
use Test::Deep;
use Test::Differences;
use Test::Exception;

use qbit;

run_tests(
    sub {
        my ($app) = @_;
        my ($context_campaign_id, $context_page_id) = (1,      1);
        my ($search_campaign_id,  $search_page_id)  = (111161, 111161);

        ####### Partner can edit mirrors with moderation only
        {
            change_cur_user($app, 'mocked-yan-partner');

            $app->context_on_site_campaign->do_action($context_campaign_id, 'edit',
                mirrors => ['newmirror.ru', 'newmirror2.ru']);
            $app->search_on_site_campaign->do_action($search_campaign_id, 'edit',
                mirrors => ['newmirror3.ru', 'newmirror4.ru']);

            cmp_deeply(
                {
                    map {$_->{domain} => $_->{moderation_status}}
                      @{$app->context_on_site_campaign->get($context_campaign_id, fields => ['mirrors'])->{mirrors}}
                },
                {
                    'newmirror.ru'  => 'new',
                    'newmirror2.ru' => 'new',
                },
                ' – added context mirrors ok'
            );
            cmp_deeply(
                {
                    map {$_->{domain} => $_->{moderation_status}}
                      @{$app->search_on_site_campaign->get($search_campaign_id, fields => ['mirrors'])->{mirrors}}
                },
                {
                    'newmirror4.ru' => 'new',
                    'newmirror3.ru' => 'new',
                },
                ' – added search mirrors ok'
            );
        }
        ok(
            $app->context_on_site_campaign->check_multistate_flag(
                $app->context_on_site_campaign->get($context_campaign_id, fields => ['multistate'])->{multistate},
                'need_update'
            ),
            ' – context page multistate is need_update ok'
          );
        ok(
            $app->search_on_site_campaign->check_multistate_flag(
                $app->search_on_site_campaign->get($search_campaign_id, fields => ['multistate'])->{multistate},
                'need_update'
            ),
            ' – search page multistate is need_update ok'
          );
        ####### Moderate mirrors
        {
            change_cur_user($app, 'mocked-moderator');

            eq_or_diff(
                \@{
                    $app->moderation->get_all(
                        fields => ['mirrors'],
                        filter => {page_id => $context_page_id, multistate => 'new'}
                      )->[0]{mirrors}
                  },
                [
                    {
                        auto              => 0,
                        domain            => "newmirror.ru",
                        id                => 6,
                        moderation_status => "new"
                    },
                    {
                        auto              => 0,
                        domain            => "newmirror2.ru",
                        id                => 7,
                        moderation_status => "new"
                    }
                ],
                ' – moderation request for context mirrors ok',
                {context => 10}
            );
            eq_or_diff(
                \@{
                    $app->moderation->get_all(
                        fields => ['mirrors'],
                        filter => {page_id => $search_page_id, multistate => 'new'}
                      )->[0]{mirrors}
                  },
                [
                    {
                        auto              => 0,
                        domain            => "newmirror3.ru",
                        id                => 5,
                        moderation_status => "new"
                    },
                    {
                        auto              => 0,
                        domain            => "newmirror4.ru",
                        id                => 6,
                        moderation_status => "new"
                    }
                ],
                ' – moderation request for search mirrors ok',
                {context => 10}
            );

            $app->moderation->do_action(
                1, 'edit',
                mirrors => [
                    {domain => "newmirror2.ru", id => 6, moderation_status => 'approved'},
                    {domain => "newmirror.ru",  id => 7, moderation_status => 'rejected'}
                ]
            );
            $app->moderation->do_action(
                2, 'edit',
                mirrors => [
                    {domain => "newmirro4.ru",  id => 5, moderation_status => 'rejected'},
                    {domain => "newmirror3.ru", id => 6, moderation_status => 'approved'}
                ]
            );

            eq_or_diff(
                \@{
                    $app->moderation->get_all(
                        fields => ['mirrors'],
                        filter => {page_id => $context_page_id, multistate => 'done'}
                      )->[0]{mirrors}
                  },
                [
                    {
                        auto              => 0,
                        domain            => "newmirror.ru",
                        id                => 6,
                        moderation_status => "approved"
                    },
                    {
                        auto              => 0,
                        domain            => "newmirror2.ru",
                        id                => 7,
                        moderation_status => "rejected"
                    }
                ],
                ' – moderated request for context mirrors ok',
                {context => 10}
            );
            cmp_deeply(
                \@{
                    $app->moderation->get_all(
                        fields => ['mirrors'],
                        filter => {page_id => $search_page_id, multistate => 'done'}
                      )->[0]{mirrors}
                  },
                [
                    {
                        auto              => 0,
                        domain            => "newmirror3.ru",
                        id                => 5,
                        moderation_status => "rejected"
                    },
                    {
                        auto              => 0,
                        domain            => "newmirror4.ru",
                        id                => 6,
                        moderation_status => "approved"
                    }
                ],
                ' – moderated request for search mirrors ok'
            );
        }

        ####### Delete moderated mirror
        {
            change_cur_user($app, 'mocked-yan-partner');

            ok(
                $app->context_on_site_campaign->check_multistate_flag(
                    $app->context_on_site_campaign->get($context_campaign_id, fields => ['multistate'])->{multistate},
                    'need_update'
                ),
                ' – context page multistate is need_update ok'
              );
            ok(
                $app->search_on_site_campaign->check_multistate_flag(
                    $app->search_on_site_campaign->get($search_campaign_id, fields => ['multistate'])->{multistate},
                    'need_update'
                ),
                ' – search page multistate is need_update ok'
              );

            cmp_deeply(
                {
                    map {$_->{domain} => $_->{moderation_status}}
                      @{$app->context_on_site_campaign->get($context_campaign_id, fields => ['mirrors'])->{mirrors}}
                },
                {'newmirror.ru' => 'approved',},
                ' – context moderated mirrors ok'
            );
            cmp_deeply(
                {
                    map {$_->{domain} => $_->{moderation_status}}
                      @{$app->search_on_site_campaign->get($search_campaign_id, fields => ['mirrors'])->{mirrors}}
                },
                {'newmirror4.ru' => 'approved',},
                ' – search moderated mirrors ok'
            );

            $app->context_on_site_campaign->do_action($context_campaign_id, 'edit', mirrors => ['newmirror2.ru']);
            $app->search_on_site_campaign->do_action($search_campaign_id, 'edit', mirrors => ['newmirror3.ru']);

            cmp_deeply(
                {
                    map {$_->{domain} => $_->{moderation_status}}
                      @{$app->context_on_site_campaign->get($context_campaign_id, fields => ['mirrors'])->{mirrors}}
                },
                {'newmirror2.ru' => 'new',},
                ' – deleted context mirror ok'
            );
            cmp_deeply(
                {
                    map {$_->{domain} => $_->{moderation_status}}
                      @{$app->search_on_site_campaign->get($search_campaign_id, fields => ['mirrors'])->{mirrors}}
                },
                {'newmirror3.ru' => 'new',},
                ' – deleted search mirror ok'
            );
        }
    },
    mocks => ['mock_zora'],
);
