#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Differences;
use Test::Partner::Utils;
use qbit;

run_tests(
    \&main_test,
    user               => 'yndx-developer',
    do_not_die_on_fail => 1,
);

sub main_test {
    my ($app) = @_;
    mock_curdate("2021-01-01 10:00:00");

    my @result;
    push @result, ["init", get_table($app)];

    my $model = $app->moderation_reason;
    my $id    = $model->add(
        manager_txt => {
            en => 'en manager_txt',
            ru => 'ру manager_txt',
        },
        partner_txt => {
            en => 'en partner_txt',
            ru => 'ру partner_txt',
        },
        timeout => 86400,
    );

    $model->add(
        id          => 1000,
        manager_txt => {
            ru => 'ру manager_txt 1000',
            en => 'en manager_txt 1000',
        },
        partner_txt => {
            ru => 'ру partner_txt 1000',
            en => 'en partner_txt 1000',
        },
        timeout => -1,
    );

    push @result, ["after add", get_table($app)];

    $model->do_action($id, "edit", manager_txt => {en => 'manager text new', ru => 'manager текст новый'});
    push @result, ["after edit", get_table($app)];

    push @result, ["for manager", get_table($app, 1)];

    change_cur_user($app, 'mocked-yan-partner');
    push @result, ["for partner", get_table($app, 1)];

    my $has = get_test_data_and_update_if_needed('data.json', \@result);
    eq_or_diff(\@result, $has, 'compare data');
}

sub get_table {
    my ($app, $only_user) = @_;
    return $app->moderation_reason->get_all(
        fields      => [qw(id manager_txt partner_txt reason_txt owner_id owner)],
        all_locales => !$only_user
    );
}
