use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Deep;

use Test::More;

run_tests(
    sub {
        my ($app) = @_;

        cmp_bag(
            $app->monetizers->get_all(fields => [qw(id caption)],),
            [
                {
                    id      => 4,
                    caption => 'google',
                },
                {
                    id      => 8,
                    caption => 'facebook',
                },
            ],
            'monetizers->get_all',
        );

    },
);
