#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::More tests => 3;
use Test::Differences;

use Test::Partner2::Simple;
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my %available_fields = ();
        my @models           = $app->blocks->get_models();
        foreach my $accessor (@models) {
            my $config = $app->get_option('api_configs', {$accessor => {}})->{$accessor} // {};

            foreach ($app->$accessor->api_available_fields($config)) {
                $available_fields{$_}++;
            }
        }

        my @fields = grep {$available_fields{$_} == @models} sort keys(%available_fields);
        my $expected = get_test_data_and_update_if_needed("data.json", \@fields);
        eq_or_diff(\@fields, $expected, 'blocks->api_available_fields');
    },
    dont_create_database => FALSE,
    user                 => 'yndx-developer',
);
