#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Deep;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my %available_fields = ();
        my @models           = $app->pages->get_models();
        foreach my $accessor (@models) {
            my $config = $app->get_option('api_configs', {$accessor => {}})->{$accessor} // {};

            foreach ($app->$accessor->api_available_fields($config)) {
                $available_fields{$_}++;
            }
        }

        my @fields = grep {$available_fields{$_} == @models} sort keys(%available_fields);

        cmp_deeply(
            \@fields,
            bag(
                qw(
                  actions
                  assistants
                  available_blocks
                  available_fields
                  available_levels
                  bk_state_id
                  bk_state_name
                  blocks_count
                  blocks_limit
                  caption
                  client_id
                  comment
                  create_date
                  cur_user_is_read_assistant
                  domain
                  editable_fields
                  excluded_domains
                  excluded_phones
                  fields_depends
                  global_excluded_domains
                  global_excluded_phones
                  id
                  is_deleted
                  is_protected
                  is_read_only
                  is_stopped
                  is_updating
                  login
                  moderation_reason
                  moderation_reason_name
                  moderation_timeout
                  moneymap
                  multistate
                  multistate_name
                  owner
                  owner_id
                  page_bk_data
                  page_id
                  patch
                  public_id
                  source_id
                  statistics_exists
                  status
                  tier
                  update_time
                  )
               ),
            'pages->api_available_fields'
        );
    },
    dont_create_database => FALSE,
    user                 => 'yndx-developer',
);
