#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Differences;
use Test::Partner::Utils;
use Test::Exception;
use qbit;

run_tests(
    sub {
        my ($app) = @_;
        mock_curdate("2019-06-24 13:40:00");

        my @result;
        my $model = $app->notification;

        throws_ok {
            $model->add(
                type       => 'custom',
                view_type  => 'default',
                ttl        => '30',
                icon_id    => 'default',
                message    => {en => 'text', ru => ('x' x 2000)},
                caption    => {en => 'header', ru => 'заголовок'},
                short_name => 'test_note',
            );
        }
        'Exception::Validator::Errors', "length error";

        my $id = $model->add(
            type       => 'custom',
            view_type  => 'default',
            ttl        => '30',
            icon_id    => 'default',
            message    => {en => 'text', ru => 'текст'},
            caption    => {en => 'header', ru => 'заголовок'},
            short_name => 'test_note',
        );
        push @result, 'data', $model->get({id => $id}, all_locales => 1);
        $model->do_action(
            $id, 'edit',
            message => {en => 'text new', ru => 'текст новый'},
            logins => ['login1', 'login2'],
            roles  => [2,        3],
        );
        push @result, 'data after edit not started',
          $model->get($id, all_locales => 1, fields => [qw(message roles roles)]);

        push @result, 'after edit not started', $model->get($id, fields => ['multistate', 'multistate_name']);

        $model->do_action($id, 'start');
        push @result, 'after start', $model->get($id, fields => ['multistate', 'multistate_name']);

        {
            my $tmp = $app->add_all_tmp_rights();
            $model->do_action($id, 'start_update');
        }
        push @result, 'after start_update', $model->get($id, fields => ['multistate', 'multistate_name']);

        {
            my $tmp = $app->add_all_tmp_rights();
            $model->do_action($id, 'stop_update');
        }
        push @result, 'after stop_update', $model->get($id, fields => ['multistate', 'multistate_name']);

        $model->do_action($id, 'edit', roles => [2]);
        push @result, 'after start', $model->get($id, fields => ['multistate', 'multistate_name']);

        {
            my $tmp = $app->add_all_tmp_rights();
            $model->do_action($id, 'start_update');
        }
        push @result, 'after start_update', $model->get($id, fields => ['multistate', 'multistate_name']);

        {
            my $tmp = $app->add_all_tmp_rights();
            $model->do_action($id, 'stop_update');
        }
        push @result, 'after stop_update', $model->get($id, fields => ['multistate', 'multistate_name']);

        $model->do_action($id, 'delete');
        push @result, 'after delete', $model->get($id, fields => ['multistate', 'multistate_name']);

        $model->do_action($id, 'restore');
        push @result, 'after restore', $model->get($id, fields => ['multistate', 'multistate_name']);

        $model->do_action($id, 'edit', roles => [2]);
        push @result, 'after edit stopped', $model->get($id, fields => ['multistate', 'multistate_name']);

        $model->do_action($id, 'start');
        push @result, 'after start', $model->get($id, fields => ['multistate', 'multistate_name']);

        my $has = get_test_data_and_update_if_needed('data.json', \@result);
        eq_or_diff(\@result, $has, 'compare data');
    },
    user               => 'yndx-developer',
    do_not_die_on_fail => 1,
);
