#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Application;
use Test::More;
use Test::Partner2::Simple;
use Test::Partner2::Mock;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        mock_bk($app);
        mock_zora($app);
        mock_mailer($app);
        mock_utils_partner2($app);

        my $site_id = $app->site->add(
            domain      => 'fake-site.ru',
            login_owner => 'mocked-yan-partner',
        );

        my $context_id = $app->context_on_site_campaign->add(
            "caption"   => 'Context page caption',
            "domain_id" => $site_id,
            login       => 'mocked-yan-partner',
        );

        my $search_id = $app->search_on_site_campaign->add(
            "caption"   => 'Search page caption',
            "domain_id" => $site_id,
            login       => 'mocked-yan-partner',
        );

        $app->site->do_action($site_id, 'approve');

        my $context_page_id = $app->context_on_site_campaign->get($context_id, fields => [qw(page_id)])->{page_id};
        my $search_page_id = $app->search_on_site_campaign->get($search_id, fields => [qw(page_id)])->{page_id};

        my @context_filters = map {$_->{filter_id}} @{
            $app->filters->get_all(
                fields => [qw(filter_id)],
                filter => {page_id => $context_page_id},
            )
          };

        my @search_filters = map {$_->{filter_id}} @{
            $app->filters->get_all(
                fields => [qw(filter_id)],
                filter => {page_id => $search_page_id},
            )
          };

        is_deeply(\@context_filters, [21], 'context filters after approve');
        is_deeply(\@search_filters,  [],   'search filters after approve');

        $context_id = $app->context_on_site_campaign->add(
            "caption"   => 'Context page caption 2',
            "domain_id" => $site_id,
            login       => 'mocked-yan-partner',
        );

        $search_id = $app->search_on_site_campaign->add(
            "caption"   => 'Search page caption 2',
            "domain_id" => $site_id,
            login       => 'mocked-yan-partner',
        );

        $context_page_id = $app->context_on_site_campaign->get($context_id, fields => [qw(page_id)])->{page_id};
        $search_page_id = $app->search_on_site_campaign->get($search_id, fields => [qw(page_id)])->{page_id};

        @context_filters = map {$_->{filter_id}} @{
            $app->filters->get_all(
                fields => [qw(filter_id)],
                filter => {page_id => $context_page_id},
            )
          };

        @search_filters = map {$_->{filter_id}} @{
            $app->filters->get_all(
                fields => [qw(filter_id)],
                filter => {page_id => $search_page_id},
            )
          };

        is_deeply(\@context_filters, [21], 'context filters already approved');
        is_deeply(\@search_filters,  [],   'search filters already approved');
    },
);
