#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Most;
use Test::More tests => 4;
use Test::Deep;
use Test::MockObject::Extends;
use Test::Partner::Utils qw(get_new_video_an_site);
use Test::Partner2::Mock;

use PiConstants qw($ADINSIDE_CLIENT_ID $BALANCE_VIPTYPE_YANDEX);

use qbit;

my $manager_login  = 'mocked-yan-manager';
my $adinside_login = 'adinside';

run_tests(
    sub {
        my ($app) = @_;

        mock_bk($app);
        mock_balance($app);
        mock_utils_partner2($app);

        $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
            my ($data) = @_;
            cmp_deeply($data->{0}->{IsYandexPage}, 1, '"adinside" video page sent to BK with IsYandexPage=1');
            return 1;
        };

        $Test::Partner2::Mock::RUN_IN_CREATE_OR_UPDATE_PLACE = sub {
            my ($operator_uid, $opts) = @_;
            cmp_deeply($opts->{InternalType}, $BALANCE_VIPTYPE_YANDEX,
                '"adinside" video page sent to Balance with InternalType=2');
            return 1;
        };

        my $page_id = $app->video_an_site->add(get_new_video_an_site({login => $adinside_login}));

        # NOTE! Почему-то во все блоки можно передать $page_id, но для пейджа это не работает
        my $page = $app->video_an_site->get_all(
            fields => [keys %{$app->video_an_site->get_model_fields()}],
            filter => {id => $page_id}
        )->[0];

        cmp_deeply($page->{is_yandex_page}, 1, '"adinside" video page got is_yandex_page=1');

    },
    user   => $manager_login,
    locale => 'en',
);
