use qbit;

use Test::Partner2::Simple;
use Test::More tests => 6;
use Test::Exception;

use Utils::ClickHouse::Local;

run_tests(
    sub {
        my ($app) = @_;

        my $input_files = ['file1', 'file2', 'file3'];
        my $output_file = 'outfile';

        {
            no warnings 'redefine';

            *Utils::ClickHouse::Local::query = sub {
                my ($self, $query) = @_;

                is_deeply($self->{input_files}, $input_files, 'input files');
                is($self->{output_file}, $output_file, 'output file');
                is_deeply(
                    $self->{structure},
                    [
                        UpdateTime    => 'DateTime',
                        PageID        => 'UInt64',
                        DSPID         => 'UInt64',
                        PublisherID   => 'String',
                        ContentID     => 'String',
                        PublisherName => 'String',
                        ContentName   => 'String',
                        Shows         => 'UInt64',
                        Wins          => 'UInt64',
                        Hits          => 'UInt64',
                        Price         => 'UInt64',
                        PartnerPrice  => 'UInt64',
                        CLID          => 'UInt64',
                    ],
                    'structure'
                );

                is(
                    $query,
                    "SELECT PageID as page_id,
                ContentID as video_content_id,
                ContentName as video_content_name,
                PublisherID as video_publisher_id,
                PublisherName as video_publisher_name,
                sum(Wins) as video_bk_all_hits,
                sum(if(DSPID == 5 OR DSPID == 10, 0, Shows)) as video_bk_shows,
                round(divide(multiply(sum(PartnerPrice), 1.2), pow(10, 6)), 2) as bk_partner_price_w_nds,
                round(divide(sum(PartnerPrice), pow(10, 6)), 2) as bk_partner_price_wo_nds,
                CLID as video_clid
         FROM table
         GROUP BY PageID, PublisherID, PublisherName, ContentID, ContentName, CLID
         ORDER BY PageID, video_bk_all_hits, PublisherID, PublisherName, ContentID, ContentName;",
                    'query'
                  );
            };
        }

        $app->video_stat_files->_aggregate_and_sort_data_files($input_files, $output_file);
    },
    fill_databases => 0,
);
