use qbit;

use Test::Partner2::Simple;
use Test::More tests => 4;
use Test::Exception;
use Archive::Zip qw(AZ_OK AZ_ERROR);

run_tests(
    sub {
        my ($app) = @_;

        is(
            Application::Model::Product::VideoAN::Site::Video::StatFiles::_build_report_name(
                12345, '2017-07-17', '2017-07-17'
            ),
            'Page ID 12345 (Statistics for 17.07.2017)',
            'one day',
          );

        is(
            Application::Model::Product::VideoAN::Site::Video::StatFiles::_build_report_name(
                12345, '2017-07-01', '2017-07-17'
            ),
            'Page ID 12345 (Statistics for 01.07.2017 - 17.07.2017)',
            'this month',
          );
    },
    locale         => 'C',
    fill_databases => 1,
    init           => [qw(video_stat_files)],
);
