use qbit;

use Test::Partner2::Simple;
use Test::More tests => 11;
use Test::Exception;
use Archive::Zip qw(AZ_OK AZ_ERROR);

run_tests(
    sub {
        my ($app) = @_;

        my $content;
        my $ar_name  = 'mocked_archive_filename';
        my $src_name = 'mocked_report_src_name';
        my $dst_name = 'mocked_report_dst_name';
        my $zip      = Archive::Zip->new();
        open(my $sh, '>', \$content);

        {
            no warnings qw(redefine once);

            *Application::Model::Product::VideoAN::Site::Video::StatFiles::tempfile = sub {
                is_deeply(\@_, [UNLINK => 1], 'tempfile args');
                return ($sh, $ar_name);
            };

            *Archive::Zip::new = sub {
                is_deeply(\@_, ['Archive::Zip'], 'Archive::Zip->new args');
                return $zip;
            };

            *Archive::Zip::Archive::addFile = sub {
                is_deeply(\@_, [$zip, $src_name, $dst_name], 'addFile args');
                return 1;
            };

            *Archive::Zip::Archive::writeToFileHandle = sub {
                is_deeply(\@_, [$zip, $sh], 'writeToFileHandle args');
                return AZ_OK;
            };
        }

        my $archive_filename = $app->video_stat_files->_create_archive($src_name => $dst_name);
        is($archive_filename, $ar_name, 'archive filename');

        {
            no warnings 'redefine';

            *Archive::Zip::Archive::writeToFileHandle = sub {
                return AZ_ERROR;
            };
        }

        throws_ok {
            $app->video_stat_files->_create_archive($src_name => $dst_name);
        }
        'Exception', 'exception';

    },
    fill_databases => 0,
    init           => [qw(video_stat_files)]
);
