use qbit;

{

    package Application::Model::Product::VideoAN::Site::Video::StatFiles;
    use subs 'open';

    use Test::More;

    sub open {
        my ($fh, $mode, $name) = @_;
        is($mode, '<', 'open mode');
        is($name, 'fake_temp_file', 'open name');
        $_[0] = 'fake_filehandle';
    }
}

use Test::Partner2::Simple;
use Test::More tests => 13;
use Test::Exception;
use Archive::Zip qw(AZ_OK AZ_ERROR);

run_tests(
    sub {
        my ($app) = @_;

        my $files;
        my $from_date = '2017-06-01';
        my $to_date   = '2017-06-02';

        {
            no warnings qw(redefine once);

            *Application::Model::StatDownloadData::get_all_most_recent = sub {
                my ($self, %args) = @_;

                is_deeply(
                    \%args,
                    {
                        fields => [qw(method stat_date filepath)],
                        filter => [
                            AND => [
                                ['method'    => '='  => 'get_publisher_stat'],
                                ['stat_date' => '>=' => $from_date],
                                ['stat_date' => '<=' => $to_date]
                            ]
                        ],
                    },
                    'get_all args'
                );

                return $files;
            };

            *Application::Model::Product::VideoAN::Site::Video::StatFiles::tempfile = sub {
                is_deeply(\@_, [UNLINK => 1], 'tempfile args');
                return (undef, 'fake_temp_file');
            };

            *Application::Model::Product::VideoAN::Site::Video::StatFiles::_aggregate_and_sort_data_files = sub {
                my ($self, $input_files, $output_file) = @_;

                is_deeply($input_files, ['fake_path_2017-06-01', 'fake_path_2017-06-02',], 'aggregation input files');
                is($output_file, 'fake_temp_file', 'aggregation output file');
            };
        }

        $files = [
            {method => 'get_publisher_stat', stat_date => '2017-06-01', filepath => 'fake_path_2017-06-01'},
            {method => 'get_publisher_stat', stat_date => '2017-06-02', filepath => 'fake_path_2017-06-02'},
        ];

        my $fh = $app->video_stat_files->_get_preprocessed_data_fh($from_date, $to_date);
        is($fh, 'fake_filehandle', 'return value');

        $files = [{method => 'get_publisher_stat', stat_date => '2017-06-01', filepath => 'fake_path_2017-06-01'},];
        throws_ok {
            $app->video_stat_files->_get_preprocessed_data_fh($from_date, $to_date);
        }
        'Exception::StatFiles', 'less files';

        $files = [
            {method => 'get_publisher_stat', stat_date => '2017-06-01', filepath => 'fake_path_2017-06-01'},
            {method => 'get_publisher_stat', stat_date => '2017-06-02', filepath => 'fake_path_2017-06-02'},
            {method => 'get_publisher_stat', stat_date => '2017-06-03', filepath => 'fake_path_2017-06-03'},
        ];
        throws_ok {
            $app->video_stat_files->_get_preprocessed_data_fh($from_date, $to_date);
        }
        'Exception::StatFiles', 'more files';
    },
    fill_databases => 0,
    init           => [qw(video_stat_files stat_download_data)]
);
