use qbit;

use Test::Partner2::Simple;
use Test::More tests => 3;
use File::Slurp qw(read_file);
use File::Temp qw(tempdir);

my $input_data = [
    {
        page_id                 => '154689',
        video_publisher_id      => '1',
        video_content_id        => '12827',
        video_publisher_name    => 'Mocked publisher',
        video_content_name      => 'Mocked content',
        video_clid              => '0',
        video_bk_shows          => '1',
        video_bk_all_hits       => '4',
        bk_partner_price_w_nds  => '1593000000',
        bk_partner_price_wo_nds => '1350000000'
    },
    {
        page_id                 => '154689',
        video_publisher_id      => '1',
        video_content_id        => '1',
        video_publisher_name    => '',
        video_content_name      => '',
        video_clid              => '0',
        video_bk_shows          => '0',
        video_bk_all_hits       => '0',
        bk_partner_price_w_nds  => '0',
        bk_partner_price_wo_nds => '0'
    },
];

my $expected = <<TSV;
Content ID\tContent name\tPublisher ID\tPublisher name\tThe sum of all hits\tShows\tRemuneration (with VAT)\tRemuneration (w/o VAT)\tCLID
12827\tMocked content\t1\tMocked publisher\t4\t1\t1593000000\t1350000000\t0
1\t\t1\t\t0\t0\t0\t0\t0
TSV

run_tests(
    sub {
        my ($app) = @_;

        $app->statistics_dsp;

        my $dir = tempdir(CLEANUP => 1);
        my $mocked_filename = "$dir/mocked_tsv";
        open(my $fh, '>:encoding(utf8)', $mocked_filename) or die "Failed to open $mocked_filename: $!";

        my $sink = $app->video_stat_files->_get_report_data_sink($fh);

        $sink->($_) for @$input_data;

        close($fh) or die "Failed to close $mocked_filename: $!";

        my $text = read_file($mocked_filename, binmode => ':utf8');

        is_deeply($text, $expected, 'tsv');
    },
    fill_databases => 0,
);
