use qbit;

use Test::Partner2::Simple;
use Test::Partner::Utils qw(mock_curdate);
use Test::More tests => 12;
my $mocked_data = [
    {
        'bk_price_w_nds'          => '0',
        'video_bk_shows_own_adv'  => 0,
        'content_id'              => '105344',
        'video_bk_hits'           => '0',
        'dt'                      => '2017-03-31 00:00:00',
        'block_id'                => undef,
        'video_bk_hits_unsold'    => 0,
        'bk_partner_price_wo_nds' => 0,
        'publisher_id'            => '',
        'bk_partner_price_w_nds'  => '0',
        'bk_price_wo_nds'         => 0,
        'currency_id'             => 2,
        'video_bk_shows'          => '0',
        'dsp_id'                  => 1,
        'page_id'                 => '139995',
        'video_bk_hits_own_adv'   => 0,
        'publisher_name'          => '',
        'video_bk_all_hits'       => '0',
        'clid'                    => '0',
        'content_name'            => 'Mocked content 1'
    },
    {
        'bk_price_w_nds'          => '0',
        'video_bk_shows_own_adv'  => 0,
        'content_id'              => '105878',
        'video_bk_hits'           => '0',
        'dt'                      => '2017-03-31 00:00:00',
        'block_id'                => undef,
        'video_bk_hits_unsold'    => 0,
        'bk_partner_price_wo_nds' => 0,
        'publisher_id'            => '',
        'bk_partner_price_w_nds'  => '0',
        'bk_price_wo_nds'         => 0,
        'currency_id'             => 2,
        'video_bk_shows'          => '0',
        'dsp_id'                  => 1,
        'page_id'                 => '139995',
        'video_bk_hits_own_adv'   => 0,
        'publisher_name'          => '',
        'video_bk_all_hits'       => '0',
        'clid'                    => '0',
        'content_name'            => 'Mocked Content 2'
    },
    {
        'bk_price_w_nds'          => '0',
        'video_bk_shows_own_adv'  => 0,
        'content_id'              => '11064',
        'video_bk_hits'           => '0',
        'dt'                      => '2017-03-31 00:00:00',
        'block_id'                => undef,
        'video_bk_hits_unsold'    => 0,
        'bk_partner_price_wo_nds' => 0,
        'publisher_id'            => '',
        'bk_partner_price_w_nds'  => '0',
        'bk_price_wo_nds'         => 0,
        'currency_id'             => 2,
        'video_bk_shows'          => '0',
        'dsp_id'                  => 1,
        'page_id'                 => '139995',
        'video_bk_hits_own_adv'   => 0,
        'publisher_name'          => '',
        'video_bk_all_hits'       => '0',
        'clid'                    => '0',
        'content_name'            => 'Mocked Content 3'
    },
    {
        'bk_price_w_nds'          => '0',
        'video_bk_shows_own_adv'  => 0,
        'content_id'              => '1113',
        'video_bk_hits'           => '1',
        'dt'                      => '2017-03-31 00:00:00',
        'block_id'                => undef,
        'video_bk_hits_unsold'    => 0,
        'bk_partner_price_wo_nds' => 0,
        'publisher_id'            => '',
        'bk_partner_price_w_nds'  => '0',
        'bk_price_wo_nds'         => 0,
        'currency_id'             => 2,
        'video_bk_shows'          => '0',
        'dsp_id'                  => 1,
        'page_id'                 => '139995',
        'video_bk_hits_own_adv'   => 0,
        'publisher_name'          => '',
        'video_bk_all_hits'       => '1',
        'clid'                    => '0',
        'content_name'            => 'Mocked Content 4'
    },
    {
        'bk_price_w_nds'          => '0',
        'video_bk_shows_own_adv'  => 0,
        'content_id'              => '11603',
        'video_bk_hits'           => '0',
        'dt'                      => '2017-03-31 00:00:00',
        'block_id'                => undef,
        'video_bk_hits_unsold'    => 0,
        'bk_partner_price_wo_nds' => 0,
        'publisher_id'            => '',
        'bk_partner_price_w_nds'  => '0',
        'bk_price_wo_nds'         => 0,
        'currency_id'             => 2,
        'video_bk_shows'          => '0',
        'dsp_id'                  => 1,
        'page_id'                 => '139995',
        'video_bk_hits_own_adv'   => 0,
        'publisher_name'          => '',
        'video_bk_all_hits'       => '0',
        'clid'                    => '0',
        'content_name'            => 'Mocked Content 5'
    },
    {
        'bk_price_w_nds'          => '0',
        'video_bk_shows_own_adv'  => 0,
        'content_id'              => '54332',
        'video_bk_hits'           => '0',
        'dt'                      => '2017-03-31 00:00:00',
        'block_id'                => undef,
        'video_bk_hits_unsold'    => 0,
        'bk_partner_price_wo_nds' => 0,
        'publisher_id'            => '',
        'bk_partner_price_w_nds'  => '0',
        'bk_price_wo_nds'         => 0,
        'currency_id'             => 2,
        'video_bk_shows'          => '0',
        'dsp_id'                  => 1,
        'page_id'                 => '123456',
        'video_bk_hits_own_adv'   => 0,
        'publisher_name'          => '',
        'video_bk_all_hits'       => '0',
        'clid'                    => '0',
        'content_name'            => 'Mocked Content 6'
    }
];

my $curdate = '2017-04-20 08:00:00';

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate($curdate);

        my $content;
        open(my $sh, '>', \$content);
        my $report_name  = 'mocked_report_filename';
        my $archive_name = 'mocked_archive_filename';
        {
            no warnings qw(redefine once);

            *Application::Model::Product::VideoAN::Site::Video::StatFiles::tempfile = sub {
                is_deeply(\@_, [UNLINK => 1], 'tempfile args');
                return ($sh, $report_name);
            };

            my $compare_idx = 0;

            *Application::Model::Product::VideoAN::Site::Video::StatFiles::_get_report_data_sink = sub {
                is($_[1], $sh, 'sink args');
                return sub {
                    is_deeply($_[0], $mocked_data->[$compare_idx++], 'sink data');
                };
            };
        }

        my $first_line = $mocked_data->[0];
        my $filename;

        my $raw_data_idx    = 1;
        my $raw_data_stream = sub {
            $mocked_data->[$raw_data_idx++];
        };

        ($first_line, $filename) =
          $app->video_stat_files->_shift_report_from_preprocessed_data($first_line, $raw_data_stream);

        is($raw_data_idx, 6,            'lines read');
        is($filename,     $report_name, 'report filenamelines readlines read');
        is_deeply($first_line, $mocked_data->[5], 'new first_line');
    },
    fill_databases => 0,
    init           => [qw(video_stat_files)],
);
