use qbit;

use Test::Partner2::Simple;
use Test::More tests => 5;
use Test::Partner::Utils qw(mock_curdate);

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate('2017-04-20 08:00:00');

        is_deeply($app->video_stat_files->_type_filter('yesterday'),
            [AND => [['from_date' => '=' => \'2017-04-19'], ['to_date' => '=' => \'2017-04-19'],]], 'yesterday');

        is_deeply($app->video_stat_files->_type_filter('this_month'),
            [AND => [['from_date' => '=' => \'2017-04-01'], ['to_date' => '=' => \'2017-04-19'],]], 'this_month');

        is_deeply(
            $app->video_stat_files->_type_filter('archive'),
            [
                AND => [
                    ['from_date' => '<' => \'2017-04-01'],
                    ['from_date' => '=' => {'DATE_FORMAT' => ['from_date', \'%Y-%m-01']}],
                    ['to_date' => '=' => {'LAST_DAY' => ['from_date']}],
                ],
            ],
            'archive'
        );
    },
    fill_databases => 0,
    init           => [qw(video_stat_files)]
);
