use qbit;

use Test::Partner2::Simple;
use Test::More;
use Test::Partner::Utils qw(mock_curdate);

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate('2017-04-20 08:00:00');

        is(
            Application::Model::Product::VideoAN::Site::Video::StatFiles::_type_from_period('2017-04-19', '2017-04-19'),
            'yesterday', 'yesterday'
          );
        is(
            Application::Model::Product::VideoAN::Site::Video::StatFiles::_type_from_period('2017-04-01', '2017-04-19'),
            'this_month', 'this_month'
          );
        is(
            Application::Model::Product::VideoAN::Site::Video::StatFiles::_type_from_period('2017-03-01', '2017-03-31'),
            'archive',
            'archive 1'
          );
        is(
            Application::Model::Product::VideoAN::Site::Video::StatFiles::_type_from_period('2017-02-01', '2017-02-28'),
            'archive',
            'archive 2'
          );
        is(
            Application::Model::Product::VideoAN::Site::Video::StatFiles::_type_from_period('2017-01-01', '2017-01-31'),
            'archive',
            'archive 3'
          );
        is(
            Application::Model::Product::VideoAN::Site::Video::StatFiles::_type_from_period('2015-04-01', '2015-04-30'),
            'archive',
            'archive 4'
          );
        is(
            Application::Model::Product::VideoAN::Site::Video::StatFiles::_type_from_period('2017-04-18', '2017-04-18'),
            undef,
            'outdated yesterday'
          );
        is(
            Application::Model::Product::VideoAN::Site::Video::StatFiles::_type_from_period('2017-04-01', '2017-04-18'),
            undef,
            'outdated this_month 1'
          );
        is(
            Application::Model::Product::VideoAN::Site::Video::StatFiles::_type_from_period('2017-01-01', '2017-01-30'),
            undef,
            'outdated this_month 2'
          );
    },
    fill_databases => 0,
    init           => [qw(video_stat_files)],
);
