use qbit;

use Test::Deep qw(cmp_deeply);

{

    package Application::Model::Product::VideoAN::Site::Video::StatFiles;
    use subs 'rand';

    sub rand {
        my ($max) = @_;
        return 1234;
    }
}

use Test::Partner2::Simple;
use Test::Partner::Utils qw(mock_curdate);
use Test::More tests => 8;

use lib::abs;
use File::Temp qw(tempdir);
use File::Copy qw(copy);
use File::Compare;
use Archive::Zip qw(AZ_OK);

run_tests(
    sub {
        my ($app) = @_;

        my $fake_data_dir = lib::abs::path('./fake_data');
        $app->stat_download_data->set_option(local_stat_cache_dir => $fake_data_dir . '/');
        mock_curdate('2017-06-04 08:00:00');
        my $dir       = tempdir(CLEANUP => 1);
        my $from_date = '2017-06-01';
        my $yesterday = '2017-06-03';

        {
            no warnings qw(redefine once);

            *Application::Model::API::Yandex::MediaStorage::S3::put_file = sub {
                my ($self, $key, $type, $filename) = @_;
                copy($filename, "$dir/$key") or die "Failed to copy $filename to $dir/$key: $!";
            };
        }

        $app->video_stat_files->generate_publisher_reports($yesterday, $yesterday);

        $app->video_stat_files->generate_publisher_reports($from_date, $yesterday);

        for my $from_date (qw(2017-06-03 2017-06-01)) {
            my $to_date = '2017-06-03';
            my $files   = $app->video_stat_files->get_all(
                fields => [qw(page_id modification_date s3_key)],
                filter => {page_id => [154689, 128972], from_date => $from_date, to_date => $to_date}
            );

            my $key_tail = "${from_date}_${to_date}_2017-06-04_08-00-00_1234.zip";

            is_deeply(
                $files,
                [
                    {
                        'modification_date' => '2017-06-04 08:00:00',
                        'page_id'           => '128972',
                        's3_key'            => "128972_$key_tail"
                    },
                    {
                        'modification_date' => '2017-06-04 08:00:00',
                        'page_id'           => '154689',
                        's3_key'            => "154689_$key_tail"
                    }
                ],
                'video_stat_files entries'
            );

            for my $page_id (154689, 128972) {
                my $zip = Archive::Zip->new("$dir/${page_id}_${key_tail}");

                unless (
                    $zip->extractMember("${page_id}_${from_date}_${to_date}.tsv", "$dir/${page_id}_got_report.tsv") ==
                    AZ_OK)
                {
                    fail("Failed to extract tsv for $page_id");
                }

                my $got    = readfile("$dir/${page_id}_got_report.tsv");
                my $expect = readfile("$fake_data_dir/${page_id}_${from_date}_${to_date}_report.tsv");

                cmp_deeply($got, $expect, "$page_id $from_date $to_date report contents");
            }
        }
    },
    init => [qw(video_stat_files api_media_storage_s3 statistics_dsp)],
);
