use qbit;

use Test::Partner2::Simple;
use Test::More;

use Exception::API::MediaStorage::S3;

run_tests(
    sub {
        my ($app) = @_;

        my %expected_to_delete_from_s3 = (
            existing_file => 1,
            missing_file  => 1,
        );

        my %expected_to_delete_from_db = (1 => 1,);

        {
            no warnings 'redefine', 'once';

            *QBit::Application::Model::DB::Table::get_all = sub {
                my ($self, %opts) = @_;
                is_deeply($opts{fields}, [qw(id s3_key)], 'get_all fields');
                is_deeply($opts{filter}, 'fake_filter', 'get_all filter');

                return [{id => 1, s3_key => 'existing_file'}, {id => 2, s3_key => 'missing_file'},];
            };

            *Application::Model::API::Yandex::MediaStorage::S3::delete = sub {
                my ($self, $key) = @_;

                delete($expected_to_delete_from_s3{$key}) or fail("Unexpected S3::delete key = $key");

                if ($key eq 'existing_file') {
                    return 1;
                } else {
                    throw Exception::API::MediaStorage::S3 'error';
                }
            };

            *QBit::Application::Model::DB::mysql::Table::delete = sub {
                my ($self, $element) = @_;

                delete($expected_to_delete_from_db{$element->{id}})
                  or fail("Unexpected mysql::Table::delete id = $element->{id}");
              }
        }

        $app->video_stat_files->delete_publisher_reports('fake_filter');

        ok(keys(%expected_to_delete_from_s3) == 0, 's3 delete all');
        ok(keys(%expected_to_delete_from_db) == 0, 'db delete all');
    },
    fill_databases => 0,
    init           => [qw(api_media_storage_s3 video_stat_files)],
);
