use qbit;

use Test::Partner2::Simple;
use Test::MockObject::Extends;
use Test::Partner::Utils qw(mock_curdate);
use Test::More tests => 40;

use File::stat;

my $mocked_data = [
    {
        'bk_price_w_nds'          => '0',
        'video_bk_shows_own_adv'  => 0,
        'content_id'              => '105344',
        'video_bk_hits'           => '0',
        'dt'                      => '2017-03-31 00:00:00',
        'block_id'                => undef,
        'video_bk_hits_unsold'    => 0,
        'bk_partner_price_wo_nds' => 0,
        'publisher_id'            => '',
        'bk_partner_price_w_nds'  => '0',
        'bk_price_wo_nds'         => 0,
        'currency_id'             => 2,
        'video_bk_shows'          => '0',
        'dsp_id'                  => 1,
        'page_id'                 => '139995',
        'video_bk_hits_own_adv'   => 0,
        'publisher_name'          => '',
        'video_bk_all_hits'       => '0',
        'clid'                    => '0',
        'content_name'            => 'Mocked content 1'
    },
    {
        'bk_price_w_nds'          => '0',
        'video_bk_shows_own_adv'  => 0,
        'content_id'              => '105878',
        'video_bk_hits'           => '0',
        'dt'                      => '2017-03-31 00:00:00',
        'block_id'                => undef,
        'video_bk_hits_unsold'    => 0,
        'bk_partner_price_wo_nds' => 0,
        'publisher_id'            => '',
        'bk_partner_price_w_nds'  => '0',
        'bk_price_wo_nds'         => 0,
        'currency_id'             => 2,
        'video_bk_shows'          => '0',
        'dsp_id'                  => 1,
        'page_id'                 => '139996',
        'video_bk_hits_own_adv'   => 0,
        'publisher_name'          => '',
        'video_bk_all_hits'       => '0',
        'clid'                    => '0',
        'content_name'            => 'Mocked Content 2'
    },
    {
        'bk_price_w_nds'          => '0',
        'video_bk_shows_own_adv'  => 0,
        'content_id'              => '11064',
        'video_bk_hits'           => '0',
        'dt'                      => '2017-03-31 00:00:00',
        'block_id'                => undef,
        'video_bk_hits_unsold'    => 0,
        'bk_partner_price_wo_nds' => 0,
        'publisher_id'            => '',
        'bk_partner_price_w_nds'  => '0',
        'bk_price_wo_nds'         => 0,
        'currency_id'             => 2,
        'video_bk_shows'          => '0',
        'dsp_id'                  => 1,
        'page_id'                 => '139997',
        'video_bk_hits_own_adv'   => 0,
        'publisher_name'          => '',
        'video_bk_all_hits'       => '0',
        'clid'                    => '0',
        'content_name'            => 'Mocked Content 3'
    },
    {
        'bk_price_w_nds'          => '0',
        'video_bk_shows_own_adv'  => 0,
        'content_id'              => '9999',
        'video_bk_hits'           => '0',
        'dt'                      => '2017-03-31 00:00:00',
        'block_id'                => undef,
        'video_bk_hits_unsold'    => 0,
        'bk_partner_price_wo_nds' => 0,
        'publisher_id'            => '',
        'bk_partner_price_w_nds'  => '0',
        'bk_price_wo_nds'         => 0,
        'currency_id'             => 2,
        'video_bk_shows'          => '0',
        'dsp_id'                  => 1,
        'page_id'                 => '98753',
        'video_bk_hits_own_adv'   => 0,
        'publisher_name'          => '',
        'video_bk_all_hits'       => '0',
        'clid'                    => '0',
        'content_name'            => 'Mocked Content From Unknown Page'
    },
];

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate('2017-04-20 08:00:00');
        my $i      = 0;
        my $stream = sub {
            return $mocked_data->[$i++];
        };
        my %trace;
        my $content;
        open(my $fh, '<', \$content);
        my $from_date        = '2017-04-01';
        my $to_date          = '2017-04-19';
        my $get_all_response = [{id => 139995}, {id => 139996}, {id => 139997},];

        {
            no warnings qw(redefine once);

            *Application::Model::Product::VideoAN::Site::Video::StatFiles::_get_preprocessed_data_fh = sub {
                my ($self, $from_date, $to_date) = @_;
                is($from_date, '2017-04-01', 'from_date');
                is($to_date,   '2017-04-19', 'to_date');
                return $fh;
            };

            *Application::Model::Product::VideoAN::Site::Video::StatFiles::_get_report_data_stream = sub {
                my ($self, $stat_fh) = @_;

                is($stat_fh, $fh, '_get_bk_data_stream fh');

                return $stream;
            };

            *QBit::Application::Model::DBManager::get_all = sub {
                my ($self, %args) = @_;

                is_deeply(\%args, {fields => [qw(id)],}, 'get_all args');

                return $get_all_response;
            };

            *Application::Model::Product::VideoAN::Site::Video::StatFiles::_shift_report_from_preprocessed_data = sub {
                my ($self, $first_line, $raw_data_stream) = @_;

                is($raw_data_stream, $stream, '_create_yesterday_report raw_data_stream');
                is_deeply($first_line, $mocked_data->[$i - 1], '_create_yesterday_report first_line');

                my $page_id     = $first_line->{page_id};
                my $report_name = "report_$page_id";

                $trace{$page_id}{report} = $report_name;

                return ($raw_data_stream->(), $report_name);
            };

            *Application::Model::Product::VideoAN::Site::Video::StatFiles::_create_archive = sub {
                my ($self, $src_name, $dst_name) = @_;

                ok($dst_name =~ m/(\d+)_2017-04-01_2017-04-19.tsv/, '_create_archive dst_name');

                my $page_id = $1;

                is($src_name, $trace{$page_id}{report}, '_create_archive src_name');

                my $archive_name = "archive_$page_id";
                $trace{$page_id}{archive} = $archive_name;
                return $archive_name;
            };

            *Application::Model::API::Yandex::MediaStorage::S3::put_file = sub {
                my ($self, $key, $type, $filename) = @_;

                is($type, 'application/zip', 's3 content type');
                ok($key =~ m/(\d+)_2017-04-01_2017-04-19_2017-04-20_08-00-00_\d+.zip/, 's3 put key');

                my $page_id = $1;
                is($filename, $trace{$page_id}{archive}, 's3 put filename');
                $trace{$page_id}{s3_key} = $key;
            };

            *Application::Model::Product::VideoAN::Site::Video::StatFiles::stat = sub ($) {
                my ($filename) = @_;

                ok($filename =~ m/archive_\d+/, 'stat filename');
                my ($page_id) = ($filename =~ m/archive_(\d+)/);
                my $mocked_stat = Test::MockObject::Extends->new(stat($filename));
                my $mocked_size = "${page_id}_mocked_size";
                $trace{$page_id}{s3_size} = $mocked_size;
                $mocked_stat->mock('size', sub {$mocked_size});

                return $mocked_stat;
            };

            *Application::Model::Product::VideoAN::Site::Video::StatFiles::add = sub {
                my ($self, %opts) = @_;

                is_deeply(
                    \%opts,
                    {
                        page_id           => $opts{page_id},
                        from_date         => '2017-04-01',
                        to_date           => '2017-04-19',
                        modification_date => '2017-04-20 08:00:00',
                        s3_key            => $trace{$opts{page_id}}{s3_key},
                        s3_size           => $trace{$opts{page_id}}{s3_size},
                    },
                    'add opts'
                );
                $trace{$opts{page_id}}{update} = 1;
            };
        }

        $app->video_stat_files->generate_publisher_reports($from_date, $to_date);

        is($i, 5, 'lines count');

        my @page_ids = map {$_->{page_id}} @$mocked_data;
        my %valid_page_ids = map {$_->{id} => 1} @$get_all_response;

        for my $page_id (@page_ids) {
            my $steps =
              $valid_page_ids{$page_id}
              ? [qw(archive report s3_key s3_size update)]
              : [qw(report)];
            is_deeply([sort keys %{$trace{$page_id}}], $steps, 'calls check');
        }
    },
    fill_databases => 0,
    init           => [qw(video_stat_files api_media_storage_s3)],
);
