use qbit;

use Test::Partner2::Simple;
use Test::Partner::Utils qw(mock_curdate);
use Test::More tests => 4;

use lib::abs;
use File::Temp qw(tempdir);
use File::Copy qw(copy);
use File::Compare;
use Archive::Zip qw(AZ_OK);

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate('2017-07-07 11:00:00');
        my $files = $app->video_stat_files->get_all(
            fields   => [qw(page_id from_date to_date modification_date)],
            order_by => [qw(page_id from_date to_date modification_date)]
        );

        my $expected = [
            {
                'modification_date' => '2017-02-02 08:00:00',
                'to_date'           => '2017-01-31',
                'page_id'           => '128972',
                'from_date'         => '2017-01-01',
            },
            {
                'modification_date' => '2017-03-02 08:00:00',
                'to_date'           => '2017-02-28',
                'page_id'           => '128972',
                'from_date'         => '2017-02-01',
            },
            {
                'modification_date' => '2017-04-02 08:00:00',
                'to_date'           => '2017-03-31',
                'page_id'           => '128972',
                'from_date'         => '2017-03-01',
            },
            {
                'modification_date' => '2017-05-02 08:00:00',
                'to_date'           => '2017-04-30',
                'page_id'           => '128972',
                'from_date'         => '2017-04-01',
            },
            {
                'modification_date' => '2017-06-02 08:00:00',
                'to_date'           => '2017-05-31',
                'page_id'           => '128972',
                'from_date'         => '2017-05-01',
            },
            {
                'modification_date' => '2017-07-02 09:00:00',
                'to_date'           => '2017-06-30',
                'page_id'           => '128972',
                'from_date'         => '2017-06-01',
            },
            {
                'modification_date' => '2017-07-07 08:00:00',
                'to_date'           => '2017-07-06',
                'page_id'           => '128972',
                'from_date'         => '2017-07-01',
            },
            {
                'modification_date' => '2017-07-07 09:00:00',
                'to_date'           => '2017-07-06',
                'page_id'           => '128972',
                'from_date'         => '2017-07-06',
            },
            {
                'modification_date' => '2017-02-02 08:00:00',
                'to_date'           => '2017-01-31',
                'page_id'           => '154689',
                'from_date'         => '2017-01-01',
            },
            {
                'modification_date' => '2017-03-02 08:00:00',
                'to_date'           => '2017-02-28',
                'page_id'           => '154689',
                'from_date'         => '2017-02-01',
            },
            {
                'modification_date' => '2017-04-02 11:00:00',
                'to_date'           => '2017-03-31',
                'page_id'           => '154689',
                'from_date'         => '2017-03-01',
            },
            {
                'modification_date' => '2017-05-02 08:00:00',
                'to_date'           => '2017-04-30',
                'page_id'           => '154689',
                'from_date'         => '2017-04-01',
            },
            {
                'modification_date' => '2017-06-02 08:00:00',
                'to_date'           => '2017-05-31',
                'page_id'           => '154689',
                'from_date'         => '2017-05-01',
            },
            {
                'modification_date' => '2017-07-02 08:00:00',
                'to_date'           => '2017-06-30',
                'page_id'           => '154689',
                'from_date'         => '2017-06-01',
            },
            {
                'modification_date' => '2017-07-07 08:00:00',
                'to_date'           => '2017-07-06',
                'page_id'           => '154689',
                'from_date'         => '2017-07-01',
            },
            {
                'modification_date' => '2017-07-07 10:00:00',
                'to_date'           => '2017-07-06',
                'page_id'           => '154689',
                'from_date'         => '2017-07-06',
            }
        ];

        is_deeply($files, $expected, '2017-07-07 11:00:00');

        mock_curdate('2017-07-02 11:00:00');
        $files = $app->video_stat_files->get_all(
            fields   => [qw(page_id from_date to_date modification_date)],
            order_by => [qw(page_id from_date to_date modification_date)]
        );

        $expected = [
            {
                'modification_date' => '2017-02-02 08:00:00',
                'to_date'           => '2017-01-31',
                'page_id'           => '128972',
                'from_date'         => '2017-01-01',
            },
            {
                'modification_date' => '2017-03-02 08:00:00',
                'to_date'           => '2017-02-28',
                'page_id'           => '128972',
                'from_date'         => '2017-02-01',
            },
            {
                'modification_date' => '2017-04-02 08:00:00',
                'to_date'           => '2017-03-31',
                'page_id'           => '128972',
                'from_date'         => '2017-03-01',
            },
            {
                'modification_date' => '2017-05-02 08:00:00',
                'to_date'           => '2017-04-30',
                'page_id'           => '128972',
                'from_date'         => '2017-04-01',
            },
            {
                'modification_date' => '2017-06-02 08:00:00',
                'to_date'           => '2017-05-31',
                'page_id'           => '128972',
                'from_date'         => '2017-05-01',
            },
            {
                'modification_date' => '2017-07-02 09:00:00',
                'to_date'           => '2017-06-30',
                'page_id'           => '128972',
                'from_date'         => '2017-06-01',
            },
            {
                'modification_date' => '2017-07-02 09:00:00',
                'to_date'           => '2017-07-01',
                'page_id'           => '128972',
                'from_date'         => '2017-07-01',
            },
            {
                'modification_date' => '2017-02-02 08:00:00',
                'to_date'           => '2017-01-31',
                'page_id'           => '154689',
                'from_date'         => '2017-01-01',
            },
            {
                'modification_date' => '2017-03-02 08:00:00',
                'to_date'           => '2017-02-28',
                'page_id'           => '154689',
                'from_date'         => '2017-02-01',
            },
            {
                'modification_date' => '2017-04-02 11:00:00',
                'to_date'           => '2017-03-31',
                'page_id'           => '154689',
                'from_date'         => '2017-03-01',
            },
            {
                'modification_date' => '2017-05-02 08:00:00',
                'to_date'           => '2017-04-30',
                'page_id'           => '154689',
                'from_date'         => '2017-04-01',
            },
            {
                'modification_date' => '2017-06-02 08:00:00',
                'to_date'           => '2017-05-31',
                'page_id'           => '154689',
                'from_date'         => '2017-05-01',
            },
            {
                'modification_date' => '2017-07-02 08:00:00',
                'to_date'           => '2017-06-30',
                'page_id'           => '154689',
                'from_date'         => '2017-06-01',
            },
            {
                'modification_date' => '2017-07-02 09:00:00',
                'to_date'           => '2017-07-01',
                'page_id'           => '154689',
                'from_date'         => '2017-07-01',
            },
        ];
        is_deeply($files, $expected, '2017-07-02 11:00:00');
    },
);
