#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Application;
use Test::Most tests => 3;
use Test::More;
use Test::Deep;
use Test::MockObject::Extends;
use Test::Partner2::Simple;
use Test::Partner2::Mock;

use Utils::DomainBK qw(@DEFAULT_VIDEO_MIRRORS);

use qbit;
run_tests(
    sub {
        my ($app) = @_;

        $app->api_bk;
        $app->{'api_bk'} = Test::MockObject::Extends->new($app->{'api_bk'});
        mock_curdate('2018-03-01 00:00:00');

        $app->api_bk->mock(
            'create_or_update_campaign',
            sub {
                my ($self, $opts) = @_;

                eq_or_diff(
                    $opts,
                    {
                        'banners_count'    => 9,
                        'business_unit'    => 0,
                        'client_id'        => 11025,
                        'create_date'      => '2017-10-04 13:31:58',
                        'description'      => 'ladyeve.ru',
                        'disabled_flags'   => [],
                        'domain'           => 'ladyeve.ru',
                        'excluded_domains' => ['ladyeve.ru'],
                        'is_yandex_page'   => 0,
                        'is_pi2'           => 1,
                        'login'            => 'tutby-partner-with-agreement',
                        'mirrors'          => \@DEFAULT_VIDEO_MIRRORS,
                        'name'             => 'ladyeve.ru',
                        'page_caption'     => 'in-page',
                        'page_id'          => 154690,
                        'page_options'     => {
                            'Disable' => ['unmoderated-rtb-auction'],
                            'Enable'  => [],
                        },
                        'places'       => {},
                        'product_id'   => 'video_an_site',
                        'product_type' => 'video',
                        'rtb_video'    => {
                            'BufferEmptyLimit'  => 5,
                            'BufferFullTimeout' => 5000,
                            'Categories'        => {
                                '0' => {
                                    'Archive' => 0,
                                    'Name'    => 'Основной домен видеоресурса',
                                },
                                '1002' => {
                                    'Archive' => 0,
                                    'Name'    => 'Другое',
                                }
                            },
                            'Contents'         => {},
                            'Platform'         => 'flash',
                            'Skin'             => 'http://storage.mds.yandex.net/get-partner/14408/default.swf',
                            'SkinTimeout'      => 2000,
                            'SkipDelay'        => 5,
                            'SkipTimeLeftShow' => 1,
                            'TimeLeftShow'     => 1,
                            'Title' =>
                              'Благодаря рекламе это видео для Вас бесплатно',
                            'VASTTimeout'     => 5000,
                            'VideoTimeout'    => 5000,
                            'VPAIDEnabled'    => 1,
                            'VPAIDTimeout'    => 5000,
                            'WrapperMaxCount' => 3,
                            'WrapperTimeout'  => 2000,
                        },
                        'sad'         => 0,
                        'state'       => 'work',
                        'target_type' => 3,
                        'OrderTags'   => [],
                        'TargetTags'  => [],
                        'update_time' => '2018-03-01 00:00:00',
                    },

                    'video_an_site->get_data_for_update',
                    {context => 5}
                );

                return 1;
            }
        );

        $app->video_an_site->do_action({id => 154690}, 'set_need_update');
        $app->video_an_site->update_in_bk({id => 154690});

    },
    user   => 'mocked-video-manager',
    locale => 'en',
);
