#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Deep;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my $func = $app->video_an_site->get_model_fields()->{'categories'}{'get'};

        my @categories =
          map {$_->{'name'} = $_->{'name'}{'en'}; $_->{'comment'} = $_->{'comment'}{'en'}; $_}
          @{$app->video_an_site_categories->get_default_video_categories('vk.com')};
        push(
            @categories,
            {
                id        => 1,
                parent_id => 0,
                name      => 'Main',
                comment   => 'Comment',
                link      => 'vk.com/login',
                archived  => 0,
            },
        );

        my $fields_obj = bless {categories => {224827 => \@categories}}, 'Mocked::Fields';
        no strict 'refs';
        no warnings 'redefine';
        *{'Mocked::Fields::model'} = sub {$app};

        my $without_yahosting = [
            {
                'link'      => 'vk.com',
                'comment'   => '',
                'name'      => 'Domain of video resourse',
                'id'        => 0,
                'archived'  => 0,
                'parent_id' => 0
            },
            {
                'link'      => 'https://www.yandex.ru/video/search',
                'comment'   => 'Video search results',
                'name'      => 'Yandex.Video',
                'id'        => 1000,
                'archived'  => 0,
                'parent_id' => 0
            },
            {
                'link'      => 'https://www.yandex.ru/video/search',
                'comment'   => 'Video search commercial',
                'name'      => 'Yandex.Video commercial',
                'id'        => 1001,
                'archived'  => 0,
                'parent_id' => 0
            },
            {
                'link'      => 'vk.com/login',
                'comment'   => 'Comment',
                'name'      => 'Main',
                'id'        => 1,
                'archived'  => 0,
                'parent_id' => 0
            }
        ];

        my $without_system = [
            {
                'link'      => 'vk.com',
                'comment'   => '',
                'name'      => 'Domain of video resourse',
                'id'        => 0,
                'archived'  => 0,
                'parent_id' => 0
            },
            {
                'link'      => 'vk.com/login',
                'comment'   => 'Comment',
                'name'      => 'Main',
                'id'        => 1,
                'archived'  => 0,
                'parent_id' => 0
            }
        ];

        my $TESTS = [
            {
                partner_type => 'kp+rsya',
                result       => $without_yahosting,
            },
            {
                partner_type => 'rsya',
                result       => $without_yahosting,
            },
            {
                partner_type => 'kp',
                result       => $without_yahosting,
            },
            {
                partner_type => 'yahosting',
                result       => \@categories,
            },
            {
                partner_type => 'kp_partner',
                result       => $without_yahosting,
            },
            {
                partner_type => undef,
                result       => $without_system,
            },
        ];

        foreach my $t (@$TESTS) {
            cmp_deeply($func->($fields_obj, {id => 224827, partner_type => $t->{'partner_type'}}),
                $t->{'result'}, $t->{'partner_type'} // 'UNDEF');
        }
    },
    dont_create_database => TRUE,
);
