#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Most;
use Test::Deep;

use Test::Partner::Utils qw(
  get_new_video_an_site
  get_new_video_instream
  get_new_video_inpage
  get_new_video_fullscreen);

use Test::Partner2::Mock qw(mock_bk mock_curdate mock_balance mock_utils_partner2);

use qbit;

use PiConstants qw($VIDEO_PLATFORM_HTML5);

run_tests(
    sub {
        my ($app) = @_;

        mock($app);
        mock_utils_partner2($app);

        my $page_id = $app->video_an_site->add(
            get_new_video_an_site(
                {
                    login        => 'mocked-video-partner',
                    platform     => $VIDEO_PLATFORM_HTML5,
                    partner_type => 'yahosting',
                }
            )
        );

        $app->partner_db->video_an_site->edit(
            $page_id,
            {
                multistate =>
                  $app->video_an_site->get_multistates_by_filter('working and not (deleted or protected)')->[0]
            }
        );

        $app->video_an_site_instream->add(get_new_video_instream({page_id => $page_id}));
        $app->video_an_site_instream->add(get_new_video_instream({page_id => $page_id, category_id => 1000}));
        $app->video_an_site_instream->add(get_new_video_instream({page_id => $page_id, category_id => 1015}));

        is(@{$app->video_an_site_instream->get_all(filter => {page_id => $page_id, multistate => 'working'})},
            3, 'working instream blocks');

        $app->video_an_site_inpage->add(get_new_video_inpage({page_id => $page_id}));
        $app->video_an_site_inpage->add(get_new_video_inpage({page_id => $page_id, category_id => 1010}));

        is(@{$app->video_an_site_inpage->get_all(filter => {page_id => $page_id, multistate => 'working'})},
            2, 'working inpage blocks');

        $app->video_an_site_fullscreen->add(get_new_video_fullscreen({page_id => $page_id}));
        $app->video_an_site_fullscreen->add(get_new_video_fullscreen({page_id => $page_id, category_id => 1013}));

        is(@{$app->video_an_site_fullscreen->get_all(filter => {page_id => $page_id, multistate => 'working'})},
            2, 'working fullscreen blocks');

        $app->video_an_site->do_action($page_id, 'edit', partner_type => 'kp');

        cmp_bag(
            $app->video_an_site_instream->get_all(
                fields => [qw(id category_id)],
                filter => {page_id => $page_id, multistate => 'working'}
            ),
            [{id => 1, category_id => 0}, {id => 2, category_id => 1000}],
            'working instream blocks without system categories'
        );

        cmp_deeply(
            $app->video_an_site_inpage->get_all(
                fields => [qw(id category_id)],
                filter => {page_id => $page_id, multistate => 'working'}
            ),
            [{id => 4, category_id => 0}],
            'working inpage blocks without system categories'
        );

        cmp_deeply(
            $app->video_an_site_fullscreen->get_all(
                fields => [qw(id category_id)],
                filter => {page_id => $page_id, multistate => 'working'}
            ),
            [{id => 6, category_id => 0}],
            'working fullscreen blocks without system categories'
        );

        $app->video_an_site->do_action($page_id, 'edit', partner_type => undef);

        cmp_deeply(
            $app->video_an_site_instream->get_all(
                fields => [qw(id category_id)],
                filter => {page_id => $page_id, multistate => 'working'}
            ),
            [{id => 1, category_id => 0}],
            'working instream blocks without search video'
        );

        cmp_deeply(
            $app->video_an_site_inpage->get_all(
                fields => [qw(id category_id)],
                filter => {page_id => $page_id, multistate => 'working'}
            ),
            [{id => 4, category_id => 0}],
            'working inpage blocks without search video'
        );

        cmp_deeply(
            $app->video_an_site_fullscreen->get_all(
                fields => [qw(id category_id)],
                filter => {page_id => $page_id, multistate => 'working'}
            ),
            [{id => 6, category_id => 0}],
            'working fullscreen blocks without search video'
        );
    },
    user   => 'mocked-yan-manager',
    locale => 'en',
);

sub mock {
    my ($app) = @_;

    mock_curdate('2017-05-31 15:52:23');

    mock_bk($app);
    mock_balance($app);
}
