#!/usr/bin/perl -w

use qbit;

use Test::Partner2::Simple;

use Test::More;
use Test::Partner2::Mock;
use Test::Deep qw(cmp_deeply re ignore bag);
use Test::MockObject::Extends;

use Test::Partner::Utils qw(
  set_test_partner_utils_app
  mock_curdate
  get_new_user
  get_new_video_an_site
  add_bookmaker_filter
  );

$Test::Partner2::Mock::PAGE_ID_START = 1;

sub test {
    my ($app) = @_;

    mock_utils_partner2($app);

    $app->{'__CURRENT_USER_RIGHTS__'} = {};

    set_test_partner_utils_app($app);

    add_bookmaker_filter($app);

    $app->api_bk;
    $app->{'api_bk'} = Test::MockObject::Extends->new($app->{'api_bk'});

    $app->api_balance;
    $app->{'api_balance'} = Test::MockObject::Extends->new($app->{'api_balance'});

    my $PAGE_ID = 0;
    $app->api_bk->mock('create_or_update_campaign', sub {++$PAGE_ID});

    $app->api_balance->mock('create_or_update_place', sub {1});

    mock_curdate('2014-03-01 00:00:00');

    my $VIDEO_PARTNER_ROLE_ID = 20;
    my $MANAGER_ROLE_ID       = 15;

    my $video_partner = get_new_user(
        users_add_opts => {id => 1, client_id => 11, login => 'video_partner'},
        role_id        => $VIDEO_PARTNER_ROLE_ID
    );

    my $video_manager =
      get_new_user(users_add_opts => {id => 2, client_id => 22}, role_id => $MANAGER_ROLE_ID, cur_user => TRUE);

    #Genres

    eval {$app->internal_genre->add()};
    is(ref($@), 'Exception::Validation::BadArguments', 'Exception is throwed.');
    is(
        ref($@) ? $@->message() : $@,
        gettext('Expected fields: %s', join(', ', qw(public_id name))),
        'Exception message is correct.'
      );

    my $internal_id = $app->internal_genre->add(public_id => 'yndx1-1', name => 'Genre 1');

    cmp_deeply(
        $app->internal_genre->get($internal_id, fields => [keys(%{$app->internal_genre->get_model_fields()})]),
        {
            'actions'          => {'edit' => re(qr(\w)),},
            'multistate_name'  => re(qr(\w)),
            'name'             => 'Genre 1',
            'create_date'      => '2014-03-01 00:00:00',
            'multistate'       => 0,
            'public_id'        => 'yndx1-1',
            'partner_genres'   => [],
            'available_fields' => ignore(),
            'id'               => 1,
            'editable_fields'  => {
                'public_id' => 1,
                'name'      => 1
            }
        },
        "Add internal genre - $internal_id"
    );

    $internal_id = $app->internal_genre->add(public_id => 'yndx1-2', name => 'Genre 2');

    cmp_deeply(
        $app->internal_genre->get($internal_id, fields => [keys(%{$app->internal_genre->get_model_fields()})]),
        {
            'actions'          => {'edit' => re(qr(\w)),},
            'multistate_name'  => re(qr(\w)),
            'name'             => 'Genre 2',
            'create_date'      => '2014-03-01 00:00:00',
            'multistate'       => 0,
            'public_id'        => 'yndx1-2',
            'partner_genres'   => [],
            'available_fields' => ignore(),
            'id'               => 2,
            'editable_fields'  => {
                'public_id' => 1,
                'name'      => 1
            }
        },
        "Add internal genre - $internal_id"
    );

    $internal_id = $app->internal_genre->add(public_id => 'yndx1-3', name => 'Genre 4');
    cmp_deeply(
        $app->internal_genre->get($internal_id, fields => [keys(%{$app->internal_genre->get_model_fields()})]),
        {
            'actions'          => {'edit' => re(qr(\w)),},
            'multistate_name'  => re(qr(\w)),
            'name'             => 'Genre 4',
            'create_date'      => '2014-03-01 00:00:00',
            'multistate'       => 0,
            'public_id'        => 'yndx1-3',
            'partner_genres'   => [],
            'available_fields' => ignore(),
            'id'               => 3,
            'editable_fields'  => {
                'public_id' => 1,
                'name'      => 1
            }
        },
        "Add internal genre - $internal_id"
    );

    $app->internal_genre->do_action($internal_id, 'edit', public_id => 'IAB24', name => 'Genre 3');

    cmp_deeply(
        $app->internal_genre->get($internal_id, fields => [keys(%{$app->internal_genre->get_model_fields()})]),
        {
            'actions'          => {'edit' => re(qr(\w)),},
            'multistate_name'  => re(qr(\w)),
            'name'             => 'Genre 3',
            'create_date'      => '2014-03-01 00:00:00',
            'multistate'       => 0,
            'public_id'        => 'IAB24',
            'partner_genres'   => [],
            'available_fields' => ignore(),
            'id'               => 3,
            'editable_fields'  => {
                'public_id' => 1,
                'name'      => 1
            }
        },
        "Edit internal genre - $internal_id"
    );

    eval {$app->partner_genre->add()};
    is(ref($@), 'Exception::Validation::BadArguments', 'Exception is throwed.');
    is(
        ref($@) ? $@->message() : $@,
        gettext('Expected fields: %s', join(', ', qw(site_id public_id name source_id))),
        'Exception message is correct.'
      );

    my $video_id = $app->video_an_site->add(get_new_video_an_site({login => 'video_partner'}));

    my $partner_id = $app->partner_genre->add(
        site_id   => $video_id,
        public_id => 1,
        name      => 'Partner genre 1',
        hits      => 320,
        source_id => 0,
    );

    cmp_deeply(
        $app->partner_genre->get($partner_id, fields => [keys(%{$app->partner_genre->get_model_fields()})]),
        {
            'internal_genres'   => [],
            'actions'           => {'edit' => re(qr(\w)),},
            'multistate_name'   => re(qr(\w)),
            'name'              => 'Partner genre 1',
            'modification_date' => '2014-03-01 00:00:00',
            'multistate'        => '0',
            'site_id'           => '1',
            'public_id'         => '1',
            'date'              => '2014-03-01',
            'hits'              => 320,
            'available_fields'  => ignore(),
            'id'                => '1',
            'editable_fields'   => {
                'public_id' => 1,
                'genres'    => 1,
                'name'      => 1
            },
            'video_an_site' => {'id' => 1, domain => 'test.video.com'},
            'domain'        => 'test.video.com',
            'source_id'     => 0,
            'source'        => re(qr(\w)),
        },
        "Add partner genre - $partner_id"
    );

    eval {$app->partner_genre->add(site_id => $video_id, public_id => 1, name => 'Partner genre 1', source_id => 1)};
    is(ref($@), 'Exception::Validation::BadArguments', 'Exception is throwed.');
    is(ref($@) ? $@->message() : $@, gettext('The genre already exists'), 'Exception message is correct.');

    cmp_deeply(
        $app->partner_genre->get_free_partner_genres(
            fields => ['id', 'public_id', 'name', 'site_id', 'domain'],
            meta   => ['found_rows']
        ),
        {
            data => [
                {
                    'site_id'   => '1',
                    'domain'    => 'test.video.com',
                    'public_id' => '1',
                    'name'      => 'Partner genre 1',
                    'id'        => '1'
                }
            ],
            meta => {found_rows => 1},
        },
        'partner_genre->get_free_partner_genres() - OK'
    );

    $app->partner_genre->do_action(
        $partner_id, 'edit',
        public_id => 'public_id 2',
        name      => 'Partner genre public_id 1',
        genres    => [1, 2]
    );

    cmp_deeply(
        $app->partner_genre->get($partner_id, fields => [keys(%{$app->partner_genre->get_model_fields()})]),
        {
            'internal_genres' => [
                {
                    'public_id' => 'yndx1-1',
                    'name'      => 'Genre 1',
                    'id'        => '1'
                },
                {
                    'public_id' => 'yndx1-2',
                    'name'      => 'Genre 2',
                    'id'        => '2'
                }
            ],
            'actions'           => {'edit' => re(qr(\w)),},
            'multistate_name'   => re(qr(\w)),
            'site_id'           => '1',
            'name'              => 'Partner genre public_id 1',
            'modification_date' => '2014-03-01 00:00:00',
            'multistate'        => '0',
            'public_id'         => 'public_id 2',
            'date'              => '2014-03-01',
            'hits'              => 320,
            'available_fields'  => ignore(),
            'id'                => '1',
            'editable_fields'   => {
                'public_id' => 1,
                'genres'    => 1,
                'name'      => 1
            },
            'video_an_site' => {'id' => 1, domain => 'test.video.com'},
            'domain'        => 'test.video.com',
            'source_id'     => 0,
            'source'        => re(qr(\w)),
        },
        "Add partner genre - $partner_id"
    );

    $partner_id =
      $app->partner_genre->add(site_id => $video_id, public_id => 2, name => 'Partner genre 2', source_id => 1);

    cmp_deeply(
        $app->partner_genre->get_free_partner_genres(meta => ['found_rows']),
        {
            data => [
                {
                    'public_id' => '2',
                    'name'      => 'Partner genre 2',
                    'id'        => $partner_id
                }
            ],
            meta => {found_rows => 1},
        },
        'partner_genre->get_free_partner_genres() - OK'
    );

    $app->partner_genre->add_into_unallocated_genres($partner_id);

    cmp_deeply(
        $app->partner_genre->get($partner_id, fields => [keys(%{$app->partner_genre->get_model_fields()})]),
        {
            'source'        => re(qr(\w)),
            'video_an_site' => {
                'domain' => 'test.video.com',
                'id'     => '1'
            },
            'actions'          => {'edit' => re(qr(\w)),},
            'date'             => '2014-03-01',
            'site_id'          => '1',
            'public_id'        => '2',
            'domain'           => 'test.video.com',
            'hits'             => '0',
            'available_fields' => ignore(),
            'id'               => '3',
            'editable_fields'  => {
                'public_id' => 1,
                'genres'    => 1,
                'name'      => 1
            },
            'source_id'       => '1',
            'internal_genres' => [
                {
                    'public_id' => 'IAB24',
                    'name'      => 'Genre 3',
                    'id'        => '3'
                }
            ],
            'modification_date' => '2014-03-01 00:00:00',
            'name'              => 'Partner genre 2',
            'multistate_name'   => re(qr(\w)),
            'multistate'        => '0'
        },
        "add_into_unallocated_genres - OK"
    );

    #CONTENTS
    $app->partner_db->content_type->add_multi([{id => 1, caption => 'Type 1'}, {id => 2, caption => 'Type 2'},]);
    $app->partner_db->content_brand->add_multi([{id => 1, caption => 'Brand 1'}, {id => 2, caption => 'Brand 2'},]);

    eval {$app->internal_content->add()};
    is(ref($@), 'Exception::Validation::BadArguments', 'Exception is throwed.');
    is(
        ref($@) ? $@->message() : $@,
        gettext('Expected fields: %s', join(', ', qw(name type_id genres))),
        'Exception message is correct.'
      );

    my $internal_content_id = $app->internal_content->add(
        name      => 'internal content 1',
        type_id   => 1,
        brand     => 'Brand 2',
        genres    => [1, 2],
        publisher => 'Publisher'
    );

    #Делает тригер
    $app->partner_db->dictionary_words->add_multi(
        [
            {content_id => $internal_content_id, word => 'internal'},
            {content_id => $internal_content_id, word => 'Content'},
            {content_id => $internal_content_id, word => '1'},
        ]
    );

    cmp_deeply(
        $app->internal_content->get(
            $internal_content_id, fields => [keys(%{$app->internal_content->get_model_fields()})]
        ),
        {
            'actions'          => {},
            'brand_id'         => '2',
            'multistate_name'  => re(qr(\w)),
            'name'             => 'internal content 1',
            'create_date'      => '2014-03-01 00:00:00',
            'brand'            => 'Brand 2',
            'partner_contents' => [],
            'publisher'        => 'Publisher',
            'multistate'       => '0',
            'genres'           => [
                {
                    'public_id' => 'yndx1-1',
                    'name'      => 'Genre 1',
                    'id'        => '1'
                },
                {
                    'public_id' => 'yndx1-2',
                    'name'      => 'Genre 2',
                    'id'        => '2'
                }
            ],
            'type_id'          => '1',
            'available_fields' => ignore(),
            'type'             => 'Type 1',
            'id'               => '1',
            'editable_fields'  => {}
        },
        "Add internal content - $internal_content_id"
    );

    $internal_content_id = $app->internal_content->add(
        name      => 'internal content 2',
        type_id   => 2,
        brand     => 'Brand 1',
        genres    => [3],
        publisher => 'Publisher 2',
    );

    #Делает тригер
    $app->partner_db->dictionary_words->add_multi(
        [
            {content_id => $internal_content_id, word => 'internal'},
            {content_id => $internal_content_id, word => 'content'},
            {content_id => $internal_content_id, word => '2'},
        ]
    );

    cmp_deeply(
        $app->internal_content->get(
            $internal_content_id, fields => [keys(%{$app->internal_content->get_model_fields()})]
        ),
        {
            'actions'          => {},
            'brand_id'         => '1',
            'multistate_name'  => re(qr(\w)),
            'name'             => 'internal content 2',
            'create_date'      => '2014-03-01 00:00:00',
            'brand'            => 'Brand 1',
            'partner_contents' => [],
            'publisher'        => 'Publisher 2',
            'multistate'       => '0',
            'genres'           => [
                {
                    'public_id' => 'IAB24',
                    'name'      => 'Genre 3',
                    'id'        => '3'
                },
            ],
            'type_id'          => '2',
            'available_fields' => ignore(),
            'type'             => 'Type 2',
            'id'               => '2',
            'editable_fields'  => {}
        },
        "Add internal content - $internal_content_id"
    );

    eval {$app->partner_content->add()};
    is(ref($@), 'Exception::Validation::BadArguments', 'Exception is throwed.');
    is(
        ref($@) ? $@->message() : $@,
        gettext('Expected fields: %s', join(', ', qw(site_id public_id name genres source_id))),
        'Exception message is correct.'
      );

    my $partner_content_id = $app->partner_content->add(
        site_id   => $video_id,
        public_id => '1',
        name      => 'Partner content 1',
        genres    => [$partner_id],
        publisher => 'Publisher 1',
        hits      => 150,
        source_id => 0,
    );

    cmp_deeply(
        $app->partner_content->get($partner_content_id, fields => [keys(%{$app->partner_content->get_model_fields()})]),
        {
            'video_an_site' => {
                'domain' => 'test.video.com',
                'id'     => '1'
            },
            'actions'          => {'edit' => re(qr(\w)),},
            'date'             => '2014-03-01',
            'site_id'          => '1',
            'public_id'        => '1',
            'domain'           => 'test.video.com',
            'internal_content' => {},
            'available_fields' => ignore(),
            'id'               => '1',
            'publisher'        => 'Publisher 1',
            'editable_fields'  => {
                'public_id'   => 1,
                'name'        => 1,
                'internal_id' => 1
            },
            'modification_date' => '2014-03-01 00:00:00',
            'name'              => 'Partner content 1',
            'multistate_name'   => re(qr(\w)),
            'internal_id'       => undef,
            'multistate'        => '0',
            'genres'            => [
                {
                    'public_id' => '2',
                    'name'      => 'Partner genre 2',
                    'id'        => '3'
                }
            ],
            'hits'      => 150,
            'source_id' => 0,
            'source'    => re(qr(\w)),
            'referer'   => '',
        },
        "Add partner content - $partner_content_id"
    );

    $partner_content_id = $app->partner_content->add(
        site_id   => $video_id,
        public_id => '2',
        name      => 'Partner content 2',
        genres    => [$partner_id],
        publisher => 'Publisher 2',
        source_id => 1,
    );

    cmp_deeply(
        $app->partner_content->get($partner_content_id, fields => [keys(%{$app->partner_content->get_model_fields()})]),
        {
            'video_an_site' => {
                'domain' => 'test.video.com',
                'id'     => '1'
            },
            'actions'          => {'edit' => re(qr(\w)),},
            'date'             => '2014-03-01',
            'site_id'          => '1',
            'public_id'        => '2',
            'domain'           => 'test.video.com',
            'internal_content' => {},
            'available_fields' => ignore(),
            'id'               => '2',
            'publisher'        => 'Publisher 2',
            'editable_fields'  => {
                'public_id'   => 1,
                'name'        => 1,
                'internal_id' => 1
            },
            'modification_date' => '2014-03-01 00:00:00',
            'name'              => 'Partner content 2',
            'multistate_name'   => re(qr(\w)),
            'internal_id'       => undef,
            'multistate'        => '0',
            'genres'            => [
                {
                    'public_id' => '2',
                    'name'      => 'Partner genre 2',
                    'id'        => '3'
                }
            ],
            'hits'      => 0,
            'source_id' => 1,
            'source'    => re(qr(\w)),
            'referer'   => '',
        },
        "Add partner content - $partner_content_id"
    );

    cmp_deeply(
        $app->partner_content->get_free_partner_contents(fields => [qw(id name public_id)], meta => ['found_rows']),
        {
            'data' => [
                {
                    'public_id' => '1',
                    'name'      => 'Partner content 1',
                    'id'        => '1'
                },
                {
                    'public_id' => '2',
                    'name'      => 'Partner content 2',
                    'id'        => '2'
                }
            ],
            'meta' => {'found_rows' => '2'}
        },
        'partner_content->get_free_partner_contents() - OK'
    );

    cmp_deeply(
        $app->internal_content->get_internal_contents_for_hint('Partner', meta => ['found_rows']),
        {
            'data' => [],
            'meta' => {'found_rows' => '0'}
        },
        'internal_content->get_internal_contents_for_hint() - OK'
    );

    cmp_deeply(
        $app->internal_content->get_internal_contents_for_hint(
            'Partner content',
            fields => [qw(id name)],
            meta   => ['found_rows']
        ),
        {
            'data' => bag(
                {
                    'name' => 'internal content 1',
                    'id'   => '1',
                },
                {
                    'name' => 'internal content 2',
                    'id'   => '2',
                }
            ),
            'meta' => {'found_rows' => '2'}
        },
        'internal_content->get_internal_contents_for_hint() - OK'
    );

    cmp_deeply(
        $app->internal_content->get_internal_contents_for_hint(
            'Partner content 2',
            fields => [qw(id name)],
            meta   => ['found_rows']
        ),
        {
            'data' => [
                {
                    'name' => 'internal content 2',
                    'id'   => '2',
                },
                {
                    'name' => 'internal content 1',
                    'id'   => '1',
                },
            ],
            'meta' => {'found_rows' => '2'}
        },
        'internal_content->get_internal_contents_for_hint() - OK'
    );

    $app->partner_content->do_action($partner_content_id, 'edit', internal_id => 2);

    cmp_deeply(
        $app->partner_content->get_free_partner_contents(fields => [qw(id name public_id)], meta => ['found_rows']),
        {
            'data' => [
                {
                    'public_id' => '1',
                    'name'      => 'Partner content 1',
                    'id'        => '1'
                }
            ],
            'meta' => {'found_rows' => '1'}
        },
        'partner_content->get_free_partner_contents() - OK'
    );
}

run_tests(
    sub {
        my ($app) = @_;
        test($app);
    },
    locale         => 'en',
    fill_databases => 0
);
