#!/usr/bin/perl

use qbit;
use Test::Partner2::Simple;

use Test::Deep qw(cmp_deeply ignore re);
use Test::More;

use Test::Partner2::Mock qw(mock_bk mock_utils_partner2);
use Test::MockObject::Extends::Easy;
use Test::Partner::Utils qw(restore_table mock_curdate add_bookmaker_filter get_new_video_an_site);

no warnings 'redefine';

# global vars
my $DEFAULT_URL = 'http://storage.mds.yandex.net/get-partner/14408/default.swf';
my $MOCKED_PAGE_ID;

# subs

sub mock_db {
    my ($app) = @_;

    mock_utils_partner2($app);

    my $table_dumps_dir = $app->get_option('ApplicationPath') . "t_old_test_data/statistics/2014_03_01/table_dumps";

    restore_table($app->partner_db->get_dbh, $table_dumps_dir, 'users');
    restore_table($app->partner_db->get_dbh, $table_dumps_dir, 'dsp');
    restore_table($app->partner_db->get_dbh, $table_dumps_dir, 'dsp_type');

    $app->partner_db->users->add(
        {
            id        => 124771297,
            login     => 'slimushkabestsonoff',
            email     => 'SlimushkaBestsonoff@yandex.ru',
            client_id => 9876,
            opts      => to_json(
                {
                    has_tutby_agreement  => 0,
                    has_common_offer     => 0,
                    has_mobile_mediation => 0,
                    has_rsya             => 1,
                    has_approved         => 0
                }
            ),
        }
    );

    $app->partner_db->user_role->add(
        {
            user_id => 124771297,
            role_id => 20,          # видеопартнер
        }
    );

    $app->partner_db->mds->add(
        {
            url       => 'http://storage.mdst.yandex.net/get-partner/1119/bq46WwYsbQ158HDCbm1iSGtAy0Y.swf',
            user_id   => 124771297,
            upload_dt => '2015-01-20 20:32:46',
            file_name => 'the_file.swf',
        }
    );

    $app->partner_db->mds->add(
        {
            url       => 'http://storage.mdst.yandex.net/get-partner/1184/bq46WwYsbQ158HDCbm1iSGt1234.swf',
            user_id   => 124771297,
            upload_dt => '2015-01-20 20:32:46',
            file_name => 'other_file.swf',
        }
    );

    $app->partner_db->tns_dict_article->add(
        {
            sid     => 0,
            grid    => 0,
            lev     => 0,
            name    => 'MAIN GROUP',
            note    => '',
            status  => 'A',
            file_id => 1590,
            hidden  => 0,
        },
    );

    return FALSE;
}

sub mock_balance {
    my ($app) = @_;

    $app->{api_balance} = Test::MockObject::Extends::Easy->new($app->{api_balance});

    $app->api_balance->mock(
        'create_or_update_place',
        sub {
            my ($self, $method, $data) = @_;

            return [];
        }
    );
}

sub create_new_video_site_with_no_skin {
    my ($app) = @_;

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        cmp_deeply(
            $data,
            {
                0 => {
                    Description  => "test.video.com",
                    Domain       => "test.video.com",
                    IsYandexPage => 0,
                    Name         => "test.video.com",
                    PartnerID    => 9876,
                    Places       => ignore(),
                    PPCTotal     => 9,
                    State        => -1,
                    TargetType   => 3,
                    BusinessUnit => 0,
                    isPi2        => 1,
                    ProductID    => 'video_an_site',
                    Login        => 'slimushkabestsonoff',
                    PageCaption  => 'Video site caption',
                },
            },
            'Sending expected data to BK',
        );

        return FALSE;
    };

    my $site_id = $app->video_an_site->add(
        get_new_video_an_site(
            {
                login               => 'slimushkabestsonoff',
                platform            => 0,                       # flash
                skip_delay          => 2,
                skip_time_left_show => 1,
                time_left_show      => 1,
            }
        )
    );

    is($site_id, 141078, 'video_an_site->add() returned expected id');

    my $data = $app->video_an_site->get_all(
        fields => [qw(id caption login skin skin_file_name)],
        filter => {id => $site_id},
    );

    is_deeply(
        $data,
        [
            {
                caption        => "Video site caption",
                id             => 141078,
                login          => "slimushkabestsonoff",
                skin           => '',
                skin_file_name => '',
            },
        ],
        'video_an_site->get_all() returned expected data with default skin',
    );

    return FALSE;
}

sub add_blocks_to_video_site_with_no_skin_and_start_testing {
    my ($app) = @_;

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        cmp_deeply(
            $data,
            {
                0 => {
                    BusinessUnit => 0,
                    Description  => "test.video.com",
                    Domain       => "test.video.com",
                    IsYandexPage => 0,
                    Mirrors      => 'yastatic.net',
                    Name         => "test.video.com",
                    PPCTotal     => 9,
                    PageID       => 141078,
                    PartnerID    => 9876,
                    Places       => ignore(),
                    ProductType  => 'video',
                    State        => -1,
                    TargetType   => 3,
                    isPi2        => 1,
                    ProductID    => 'video_an_site',
                    Login        => 'slimushkabestsonoff',
                    PageCaption  => 'Video site caption',
                    CreateDate   => '2016-07-15 18:08:55',
                    RtbVideo     => {
                        BufferEmptyLimit  => 2,
                        BufferFullTimeout => 500,
                        Categories        => {
                            0 => {
                                Archive => 0,
                                Name    => re(qr(\w)),
                            },
                        },
                        Contents => ignore(),
                        Platform => "flash",
                        #                        RF       => {
                        #                            Interval   => 604800,
                        #                            ShowsCount => 25,
                        #                        },
                        Skin             => "http://storage.mds.yandex.net/get-partner/14408/default.swf",
                        SkinTimeout      => 2000,
                        SkipDelay        => 2,
                        SkipTimeLeftShow => 100,
                        TimeLeftShow     => 100,
                        Title            => "title",
                        VASTTimeout      => 500,
                        VideoTimeout     => 500,
                        VPAIDEnabled     => 1,
                        VPAIDTimeout     => 50,
                        WrapperMaxCount  => 3,
                        WrapperTimeout   => 1000,
                    },
                    RtbBlocks => {
                        1 => {
                            AdFoxBlock => 0,
                            AdType     => ignore(),
                            AdTypeSet  => {
                                media               => 0,
                                'media-performance' => 0,
                                text                => 0,
                                video               => 1,
                                'video-performance' => 1,
                            },
                            AlternativeCode => undef,
                            Article         => ignore(),
                            BlindLevel      => 0,
                            BlockCaption    => 'block sample caption',
                            MultiState      => 4,
                            Brand           => ignore(),
                            DSPInfo         => [
                                {
                                    'DSPID' => 2563070,
                                    'RF'    => {
                                        'Interval'   => 0,
                                        'ShowsCount' => 0
                                    },
                                    'CPM' => 0
                                }
                            ],
                            DSPType => 2,
                            Geo     => ignore(),
                            page_id => 141078,
                            Video   => {
                                API            => [2,],
                                CategoryID     => 0,
                                CountPositions => 3,
                                MaxDuration    => 180,
                                Protocols      => [2, 5,],
                                StartTime      => 0,
                                Type           => "postroll",
                            },
                        },
                    },
                    PageOptions => {Enable => [], Disable => [],},
                },
            },
            'Sending expected data to BK',
        );

        return FALSE;
    };

    my $result = $app->video_an_site_instream->add(
        page_id                   => 141078,
        caption                   => 'block sample caption',
        category_id               => 0,
        type                      => 1,
        max_duration              => 180,
        count_positions           => 3,
        dsps                      => [{dsp_id => '2563070'}],
        strategy                  => 3,
        mincpm                    => undef,
        video_active              => 1,
        video_blocked             => 1,
        video_cpm                 => undef,
        video_performance_active  => 1,
        video_performance_blocked => 0,
        video_performance_cpm     => 30,
    );

    is_deeply($result, 'R-V-141078-1', 'video_an_site_instream->add() returned expected data',);

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        cmp_deeply(
            $data,
            {
                0 => {
                    Description  => "test.video.com",
                    Domain       => "test.video.com",
                    IsYandexPage => 0,
                    Mirrors      => "yastatic.net",
                    Name         => "test.video.com",
                    PageID       => 141078,
                    PartnerID    => 9876,
                    Places       => ignore(),
                    PPCTotal     => 9,
                    State        => 0,
                    TargetType   => 3,
                    ProductType  => 'video',
                    RtbVideo     => {
                        BufferEmptyLimit  => 2,
                        BufferFullTimeout => 500,
                        Categories        => {
                            0 => {
                                Archive => 0,
                                Name    => re(qr(\w)),
                            },
                        },
                        Contents => ignore(),
                        #                        RF       => {
                        #                            Interval   => 604800,
                        #                            ShowsCount => 25,
                        #                        },
                        Skin             => "http://storage.mds.yandex.net/get-partner/14408/default.swf",
                        SkinTimeout      => 2000,
                        SkipDelay        => 2,
                        SkipTimeLeftShow => 100,
                        TimeLeftShow     => 100,
                        Title            => "title",
                        VASTTimeout      => 500,
                        VideoTimeout     => 500,
                        VPAIDEnabled     => 1,
                        VPAIDTimeout     => 50,
                        WrapperMaxCount  => 3,
                        WrapperTimeout   => 1000,
                        Platform         => 'flash',
                    },
                    BusinessUnit => 0,
                    isPi2        => 1,
                    ProductID    => 'video_an_site',
                    Login        => 'slimushkabestsonoff',
                    PageCaption  => 'Video site caption',
                    CreateDate   => '2016-07-15 18:08:55',
                    RtbBlocks    => {
                        1 => {
                            AdFoxBlock => 0,
                            AdType     => ignore(),
                            AdTypeSet  => {
                                media               => 0,
                                'media-performance' => 0,
                                text                => 0,
                                video               => 1,
                                'video-performance' => 1,
                            },
                            AlternativeCode => undef,
                            Article         => ignore(),
                            BlindLevel      => 0,
                            BlockCaption    => 'block sample caption',
                            MultiState      => 6,
                            Brand           => ignore(),
                            DSPInfo         => [
                                {
                                    'DSPID' => 2563070,
                                    'RF'    => {
                                        'Interval'   => 0,
                                        'ShowsCount' => 0
                                    },
                                    'CPM' => 0
                                }
                            ],
                            DSPType => 2,
                            Geo     => ignore(),
                            page_id => 141078,
                            Video   => {
                                API            => [2,],
                                CategoryID     => 0,
                                CountPositions => 3,
                                MaxDuration    => 180,
                                Protocols      => [2, 5,],
                                StartTime      => 0,
                                Type           => "postroll",
                            },
                        },
                    },
                    PageOptions => {Enable => [], Disable => [],},

                },
            },
            'Sending expected data to BK',
        );

        return FALSE;
    };

    my $multistate = $app->video_an_site->do_action(141078, 'start_testing',);

    # 2  - testing, 64 - need_update
    is($multistate, 66, 'got expected multistate after action "start_testing"');

    return FALSE;
}

sub cant_change_skin_to_incorrect {
    my ($app) = @_;

    eval {my $edit_result = $app->video_an_site->do_action(141078, 'edit', skin => 'http://test.video.com/skin.swf');};

    like($@->message, qr/Cannot use URL .*? for skinization/, 'Got expected error when trying to set incorrect skin');

    my $data = $app->video_an_site->get_all(
        fields => [qw(id caption login skin skin_file_name)],
        filter => {id => 141078},
    );

    is_deeply(
        $data,
        [
            {
                caption        => "Video site caption",
                id             => 141078,
                login          => "slimushkabestsonoff",
                skin           => '',
                skin_file_name => '',
            },
        ],
        'video_an_site->get_all() returned expected data with no skin',
    );

    return FALSE;
}

sub change_skin {
    my ($app) = @_;

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        cmp_deeply(
            $data,
            {
                0 => {
                    Description  => "test.video.com",
                    Domain       => "test.video.com",
                    IsYandexPage => 0,
                    Mirrors      => "yastatic.net",
                    Name         => "test.video.com",
                    PageID       => 141078,
                    PartnerID    => 9876,
                    Places       => ignore(),
                    PPCTotal     => 9,
                    State        => 0,
                    TargetType   => 3,
                    ProductType  => 'video',
                    RtbVideo     => {
                        BufferEmptyLimit  => 2,
                        BufferFullTimeout => 500,
                        Categories        => {
                            0 => {
                                Archive => 0,
                                Name    => re(qr(\w)),
                            },
                        },
                        Contents => ignore(),
                        #                        RF       => {
                        #                            Interval   => 604800,
                        #                            ShowsCount => 25,
                        #                        },
                        Skin => 'http://storage.mdst.yandex.net/get-partner/1119/bq46WwYsbQ158HDCbm1iSGtAy0Y.swf',
                        SkinTimeout      => 2000,
                        SkipDelay        => 2,
                        SkipTimeLeftShow => 1,
                        TimeLeftShow     => 1,
                        Title            => "title",
                        VASTTimeout      => 500,
                        VideoTimeout     => 500,
                        VPAIDEnabled     => 1,
                        VPAIDTimeout     => 50,
                        WrapperMaxCount  => 3,
                        WrapperTimeout   => 1000,
                        Platform         => 'flash',
                    },
                    BusinessUnit => 0,
                    isPi2        => 1,
                    ProductID    => 'video_an_site',
                    Login        => 'slimushkabestsonoff',
                    PageCaption  => 'Video site caption',
                    CreateDate   => '2016-07-15 18:08:55',
                    RtbBlocks    => {
                        1 => {
                            AdFoxBlock => 0,
                            AdType     => ignore(),
                            AdTypeSet  => {
                                media               => 0,
                                'media-performance' => 0,
                                text                => 0,
                                video               => 1,
                                'video-performance' => 1,
                            },
                            AlternativeCode => undef,
                            Article         => ignore(),
                            BlindLevel      => 0,
                            BlockCaption    => 'block sample caption',
                            MultiState      => 6,
                            Brand           => ignore(),
                            DSPInfo         => [
                                {
                                    'DSPID' => 2563070,
                                    'RF'    => {
                                        'Interval'   => 0,
                                        'ShowsCount' => 0
                                    },
                                    'CPM' => 0
                                }
                            ],
                            DSPType => 2,
                            Geo     => ignore(),
                            page_id => 141078,
                            Video   => {
                                API            => [2,],
                                CategoryID     => 0,
                                CountPositions => 3,
                                MaxDuration    => 180,
                                Protocols      => [2, 5,],
                                StartTime      => 0,
                                Type           => "postroll",
                            },
                        },
                    },
                    PageOptions => {Enable => [], Disable => [],},

                },
            },
            'Sending expected data to BK',
        );

        return FALSE;
    };

    my $edit_result = $app->video_an_site->do_action(141078, 'edit',
        skin => 'http://storage.mdst.yandex.net/get-partner/1119/bq46WwYsbQ158HDCbm1iSGtAy0Y.swf',);

    my $data = $app->video_an_site->get_all(
        fields => [qw(id caption login skin skin_file_name)],
        filter => {id => 141078},
    );

    is_deeply(
        $data,
        [
            {
                caption        => "Video site caption",
                id             => 141078,
                login          => "slimushkabestsonoff",
                skin           => 'http://storage.mdst.yandex.net/get-partner/1119/bq46WwYsbQ158HDCbm1iSGtAy0Y.swf',
                skin_file_name => 'the_file.swf',
            },
        ],
        'video_an_site->get_all() returned expected data with changed skin',
    );

    return FALSE;
}

sub remove_skin {
    my ($app) = @_;

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        cmp_deeply(
            $data,
            {
                0 => {
                    Description  => "test.video.com",
                    Domain       => "test.video.com",
                    IsYandexPage => 0,
                    Mirrors      => "yastatic.net",
                    Name         => "test.video.com",
                    PageID       => 141078,
                    PartnerID    => 9876,
                    Places       => ignore(),
                    PPCTotal     => 9,
                    State        => 0,
                    TargetType   => 3,
                    ProductType  => 'video',
                    isPi2        => 1,
                    ProductID    => 'video_an_site',
                    Login        => 'slimushkabestsonoff',
                    PageCaption  => 'Video site caption',
                    CreateDate   => '2016-07-15 18:08:55',
                    RtbVideo     => {
                        BufferEmptyLimit  => 2,
                        BufferFullTimeout => 500,
                        Categories        => {
                            0 => {
                                Archive => 0,
                                Name    => re(qr(\w)),
                            },
                        },
                        Contents => ignore(),
                        #                        RF       => {
                        #                            Interval   => 604800,
                        #                            ShowsCount => 25,
                        #                        },
                        Skin             => $DEFAULT_URL,
                        SkinTimeout      => 2000,
                        SkipDelay        => 2,
                        SkipTimeLeftShow => 1,
                        TimeLeftShow     => 1,
                        Title            => "title",
                        VASTTimeout      => 500,
                        VideoTimeout     => 500,
                        VPAIDEnabled     => 1,
                        VPAIDTimeout     => 50,
                        WrapperMaxCount  => 3,
                        WrapperTimeout   => 1000,
                        Platform         => 'flash',
                    },
                    BusinessUnit => 0,
                    RtbBlocks    => {
                        1 => {
                            AdFoxBlock => 0,
                            AdType     => ignore(),
                            AdTypeSet  => {
                                media               => 0,
                                'media-performance' => 0,
                                text                => 0,
                                video               => 1,
                                'video-performance' => 1,
                            },
                            AlternativeCode => undef,
                            Article         => ignore(),
                            BlindLevel      => 0,
                            Brand           => ignore(),
                            BlockCaption    => 'block sample caption',
                            MultiState      => 6,
                            DSPInfo         => [
                                {
                                    'DSPID' => 2563070,
                                    'RF'    => {
                                        'Interval'   => 0,
                                        'ShowsCount' => 0
                                    },
                                    'CPM' => 0
                                }
                            ],
                            DSPType => 2,
                            Geo     => ignore(),
                            page_id => 141078,
                            Video   => {
                                API            => [2,],
                                CategoryID     => 0,
                                CountPositions => 3,
                                MaxDuration    => 180,
                                Protocols      => [2, 5,],
                                StartTime      => 0,
                                Type           => "postroll",
                            },
                        },
                    },
                    PageOptions => {Enable => [], Disable => [],},
                },
            },
            'Sending expected data to BK',
        );

        return FALSE;
    };

    my $edit_result = $app->video_an_site->do_action(141078, 'edit', skin => '',);

    my $data = $app->video_an_site->get_all(
        fields => [qw(id caption login skin skin_file_name)],
        filter => {id => 141078},
    );

    is_deeply(
        $data,
        [
            {
                caption        => "Video site caption",
                id             => 141078,
                login          => "slimushkabestsonoff",
                skin           => '',
                skin_file_name => '',
            },
        ],
        'video_an_site->get_all() returned expected data with removed skin',
    );

    return FALSE;
}

sub cant_create_new_video_site_with_incorrect_skin {
    my ($app) = @_;

    eval {
        my $site_id = $app->video_an_site->add(
            domain              => 'test.video.com',
            caption             => 'Video site caption',
            login               => 'slimushkabestsonoff',
            platform            => 0,                                  # flash
            title               => 'title',
            skip_delay          => 2,
            skip_time_left_show => 1,
            time_left_show      => 1,
            vpaid_enabled       => 1,
            vpaid_timeout       => 50,
            skin                => 'http://test.video.com/skin.swf',
        );
    };

    like($@->message, qr/Cannot use URL .*? for skinization/, 'Got expected error when trying to set incorrect skin');

    return FALSE;
}

sub create_new_video_site_with_skin {
    my ($app) = @_;

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        cmp_deeply(
            $data,
            {
                0 => {
                    Description  => "test.video.com",
                    Domain       => "test.video.com",
                    IsYandexPage => 0,
                    Name         => "test.video.com",
                    PartnerID    => 9876,
                    Places       => ignore(),
                    PPCTotal     => 9,
                    State        => -1,
                    TargetType   => 3,
                    BusinessUnit => 0,
                    isPi2        => 1,
                    ProductID    => 'video_an_site',
                    Login        => 'slimushkabestsonoff',
                    PageCaption  => 'Video site caption',
                },
            },
            'Sending expected data to BK',
        );

        return FALSE;
    };

    my $site_id = $app->video_an_site->add(
        domain              => 'test.video.com',
        caption             => 'Video site caption',
        login               => 'slimushkabestsonoff',
        platform            => 0,                                                                                # flash
        title               => 'title',
        skip_delay          => 2,
        skip_time_left_show => 1,
        time_left_show      => 1,
        vpaid_enabled       => 1,
        vpaid_timeout       => 50,
        skin                => 'http://storage.mdst.yandex.net/get-partner/1184/bq46WwYsbQ158HDCbm1iSGt1234.swf',
    );

    is($site_id, 141079, 'video_an_site->add() returned expected id');

    my $data = $app->video_an_site->get_all(
        fields => [qw(id caption login skin skin_file_name)],
        filter => {id => $site_id},
    );

    is_deeply(
        $data,
        [
            {
                caption        => "Video site caption",
                id             => 141079,
                login          => "slimushkabestsonoff",
                skin           => 'http://storage.mdst.yandex.net/get-partner/1184/bq46WwYsbQ158HDCbm1iSGt1234.swf',
                skin_file_name => 'other_file.swf',
            },
        ],
        'video_an_site->get_all() returned expected data with default skin 2',
    );

    return FALSE;
}

sub add_blocks_to_video_site_with_skin_and_start_testing {
    my ($app) = @_;

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        cmp_deeply(
            $data,
            {
                0 => {
                    BusinessUnit => 0,
                    Description  => "test.video.com",
                    Domain       => "test.video.com",
                    IsYandexPage => 0,
                    Mirrors      => "yastatic.net",
                    Name         => "test.video.com",
                    PPCTotal     => 9,
                    PageID       => 141079,
                    PartnerID    => 7262551,
                    Places       => ignore(),
                    ProductType  => "video",
                    State        => -1,
                    TargetType   => 3,
                    isPi2        => 1,
                    ProductID    => 'video_an_site',
                    Login        => 'slimushkabestsonoff',
                    PageCaption  => 'Video site caption',
                    CreateDate   => '2016-07-15 18:08:55',
                    RtbVideo     => {
                        BufferEmptyLimit  => 2,
                        BufferFullTimeout => 500,
                        Categories        => {
                            0 => {
                                Archive => 0,
                                Name    => re(qr(\w)),
                            },
                        },
                        Contents => ignore(),
                        Platform => "flash",
                        #                        RF       => {
                        #                            Interval   => 604800,
                        #                            ShowsCount => 25,
                        #                        },
                        Skin => "http://storage.mdst.yandex.net/get-partner/1184/bq46WwYsbQ158HDCbm1iSGt1234.swf",
                        SkinTimeout      => 2000,
                        SkipDelay        => 2,
                        SkipTimeLeftShow => 1,
                        TimeLeftShow     => 1,
                        Title            => "title",
                        VASTTimeout      => 500,
                        VideoTimeout     => 500,
                        VPAIDEnabled     => 1,
                        VPAIDTimeout     => 50,
                        WrapperMaxCount  => 3,
                        WrapperTimeout   => 1000,
                    },
                    RtbBlocks => {
                        1 => {
                            AdFoxBlock => 0,
                            AdType     => ignore(),
                            AdTypeSet  => {
                                media               => 0,
                                'media-performance' => 0,
                                text                => 0,
                                video               => 1,
                                'video-performance' => 1,
                            },
                            AlternativeCode => undef,
                            Article         => ignore(),
                            BlindLevel      => 0,
                            BlockCaption    => 'block sample caption',
                            MultiState      => 4,
                            Brand           => ignore(),
                            DSPInfo         => [
                                {
                                    'DSPID' => 2563070,
                                    'RF'    => {
                                        'Interval'   => 0,
                                        'ShowsCount' => 0
                                    },
                                    'CPM' => 0
                                }
                            ],
                            DSPType => 2,
                            Geo     => ignore(),
                            page_id => 141079,
                            Video   => {
                                API            => [2,],
                                CategoryID     => 0,
                                CountPositions => 3,
                                MaxDuration    => 180,
                                Protocols      => [2, 5,],
                                StartTime      => 0,
                                Type           => "postroll",
                            },
                        },
                    },
                    PageOptions => {Enable => [], Disable => [],},
                },
            },
            'Sending expected data to BK',
        );

        return FALSE;
    };

    my $result = $app->video_an_site_instream->add(
        page_id                   => 141079,
        caption                   => 'block sample caption',
        category_id               => 0,
        type                      => 1,
        max_duration              => 180,
        count_positions           => 3,
        dsps                      => [{dsp_id => '2563070'}],
        strategy                  => 3,
        mincpm                    => undef,
        video_active              => 1,
        video_blocked             => 1,
        video_cpm                 => undef,
        video_performance_active  => 1,
        video_performance_blocked => 0,
        video_performance_cpm     => 30,
    );

    is_deeply($result, 'R-V-141079-1', 'video_an_site_instream->add() returned expected data',);

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        cmp_deeply(
            $data,
            {
                0 => {
                    Description  => "test.video.com",
                    Domain       => "test.video.com",
                    IsYandexPage => 0,
                    Mirrors      => "yastatic.net",
                    Name         => "test.video.com",
                    PageID       => 141079,
                    PartnerID    => 9876,
                    Places       => ignore(),
                    PPCTotal     => 9,
                    State        => 0,
                    TargetType   => 3,
                    ProductType  => 'video',
                    RtbVideo     => {
                        BufferEmptyLimit  => 2,
                        BufferFullTimeout => 500,
                        Categories        => {
                            0 => {
                                Archive => 0,
                                Name    => re(qr(\w)),
                            },
                        },
                        Contents => ignore(),
                        #                        RF       => {
                        #                            Interval   => 604800,
                        #                            ShowsCount => 25,
                        #                        },
                        Skin => 'http://storage.mdst.yandex.net/get-partner/1184/bq46WwYsbQ158HDCbm1iSGt1234.swf',
                        SkinTimeout      => 2000,
                        SkipDelay        => 2,
                        SkipTimeLeftShow => 1,
                        TimeLeftShow     => 1,
                        Title            => "title",
                        VASTTimeout      => 500,
                        VideoTimeout     => 500,
                        VPAIDEnabled     => 1,
                        VPAIDTimeout     => 50,
                        WrapperMaxCount  => 3,
                        WrapperTimeout   => 1000,
                        Platform         => 'flash',
                    },
                    BusinessUnit => 0,
                    isPi2        => 1,
                    ProductID    => 'video_an_site',
                    Login        => 'slimushkabestsonoff',
                    PageCaption  => 'Video site caption',
                    CreateDate   => '2016-07-15 18:08:55',
                    RtbBlocks    => {
                        1 => {
                            AdFoxBlock => 0,
                            AdType     => ignore(),
                            AdTypeSet  => {
                                media               => 0,
                                'media-performance' => 0,
                                text                => 0,
                                video               => 1,
                                'video-performance' => 1,
                            },
                            AlternativeCode => undef,
                            Article         => ignore(),
                            BlindLevel      => 0,
                            Brand           => ignore(),
                            BlockCaption    => 'block sample caption',
                            MultiState      => 6,
                            DSPInfo         => [
                                {
                                    'DSPID' => 2563070,
                                    'RF'    => {
                                        'Interval'   => 0,
                                        'ShowsCount' => 0
                                    },
                                    'CPM' => 0
                                }
                            ],
                            DSPType => 2,
                            Geo     => ignore(),
                            page_id => 141079,
                            Video   => {
                                API            => [2,],
                                CategoryID     => 0,
                                CountPositions => 3,
                                MaxDuration    => 180,
                                Protocols      => [2, 5,],
                                StartTime      => 0,
                                Type           => "postroll",
                            },
                        },
                    },
                    PageOptions => {Enable => [], Disable => [],},
                },
            },
            'Sending expected data to BK',
        );

        return FALSE;
    };

    my $multistate = $app->video_an_site->do_action(141079, 'start_testing',);

    # 2  - testing, 64 - need_update
    is($multistate, 66, 'got expected multistate after action "start_testing"');

    return FALSE;
}

run_tests(
    sub {
        my ($app) = @_;

        mock_db($app);
        mock_bk($app);
        mock_balance($app);
        add_bookmaker_filter($app);
        mock_curdate('2016-07-15 18:08:55');

        change_cur_user($app, 'slimushkabestsonoff');

        {
            no strict 'refs';
            no warnings 'redefine';
            *{'QBit::Application::check_rights'} = sub {TRUE};
        }

        $Test::Partner2::Mock::PAGE_ID_START = 141078;
        $MOCKED_PAGE_ID                      = $Test::Partner2::Mock::PAGE_ID_START;
        create_new_video_site_with_no_skin($app);
        add_blocks_to_video_site_with_no_skin_and_start_testing($app);
        cant_change_skin_to_incorrect($app);
        change_skin($app);
        remove_skin($app);

        $Test::Partner2::Mock::PAGE_ID_START = 141079;
        $MOCKED_PAGE_ID                      = $Test::Partner2::Mock::PAGE_ID_START;
        cant_create_new_video_site_with_incorrect_skin($app);
        create_new_video_site_with_skin($app);
        add_blocks_to_video_site_with_skin_and_start_testing($app);

    },
    fill_databases     => 0,
    locale             => "en",
    init               => [qw(api_bk api_balance)],
    do_not_die_on_fail => TRUE,
);
__END__
