#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;

use qbit;

my $USER_ID = 155209804;

sub main_test {
    my ($app) = @_;

    my $queues = $app->queue->get_all(fields => [qw(id multistate params_ref)], filter => {method_type => 11});

    ok(!@$queues, 'does not exist task with method_type 11');

    foreach my $page_accessor (sort @{$app->product_manager->get_page_model_accessors()}) {
        my @page_ids =
          map {$_->{'page_id'}}
          @{$app->$page_accessor->get_all(fields => [qw(page_id)], filter => {multistate => 'working'})};

        next unless @page_ids;

        my @proxy_models =
          sort map {$_->accessor()}
          grep     {$_->DOES('Application::Model::Role::JavaJsonApiProxy')} $app->$page_accessor->get_block_models();

        foreach my $page_id (@page_ids) {
            my $working_blocks = _get_working_blocks($app->$page_accessor, $page_id);

            $app->$page_accessor->do_all_block_action($page_id, 'stop');

            my $working_blocks_after_stop = _get_working_blocks($app->$page_accessor, $page_id);

            my @proxy_models_with_working_blocks = grep {exists($working_blocks->{$_})} @proxy_models;

            if (@proxy_models_with_working_blocks) {
                cmp_deeply(
                    $working_blocks_after_stop,
                    {map {$_ => $working_blocks->{$_}} @proxy_models_with_working_blocks},
                    'page_id: %d - Blocks do not implement JavaJsonApiProxy have been stopped only'
                );
            } else {
                ok(keys(%$working_blocks_after_stop) == 0,
                    sprintf('accessor: %s, page_id: %d - all blocks have been stopped', $page_accessor, $page_id));
            }

            my $queues_after_stop = $app->queue->get_all(
                fields   => [qw(id group_id multistate params_ref)],
                filter   => ['AND', [{method_type => 11}, ['id', 'NOT IN', [map {$_->{'id'}} @$queues]]]],
                order_by => ['id']
            );

            ok(
                @$queues_after_stop == @proxy_models,
                sprintf(
                    'accessor: %s, page_id: %d - for all proxy models have been created a task',
                    $page_accessor, $page_id
                )
              );

            my $expected = [
                map {
                    {
                        id         => ignore(),
                        group_id   => $page_id,
                        multistate => 0,
                        params_ref => {
                            userId     => $USER_ID,
                            actionName => 'stop',
                            modelName  => $_,
                            pageId     => $page_id
                        }
                    }
                  } @proxy_models
            ];

            cmp_deeply($queues_after_stop, $expected,
                sprintf('accessor: %s, page_id: %d - tasks have been created correct', $page_accessor, $page_id));

            push(@$queues, @$queues_after_stop);
        }
    }
}

sub _get_working_blocks {
    my ($page_accessor, $page_id) = @_;

    my $working_blocks = {};
    my @block_models   = $page_accessor->get_block_models();
    foreach my $block_model (@block_models) {
        my $blocks = $block_model->get_all(
            fields => [qw(public_id multistate)],
            filter => {page_id => $page_id, multistate => 'working'}
        );

        my $accessor = $block_model->accessor();

        foreach (@$blocks) {
            $working_blocks->{$accessor}{$_->{'public_id'}} = $_;
        }
    }

    return $working_blocks;
}

run_tests(\&main_test);
