#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Most;
use Test::Deep;
use Test::More;

use qbit;

my %covers = map {$_ => TRUE} (
    'search_on_site_campaign',
    'internal_search_on_site_campaign',
    'internal_mobile_app',
    'internal_context_on_site_campaign',
    'context_on_site_campaign',
    #'mobile_app_settings', - page_id
);

run_tests(
    sub {
        my ($app) = @_;

        for my $model (@{$app->product_manager->get_page_model_accessors}) {
            my $all = $app->$model->get_model_fields();
            my $add = $app->$model->get_add_fields();

            my @fail;
            for my $field (grep {$add->{$_}} keys %$add) {
                unless (exists $all->{$field}{need_check}) {
                    push @fail, $field;
                }
            }
          SKIP: {
                skip "$model " . @fail, 1 unless $covers{$model};
                ok(!@fail, $model) or diag "fields: " . join(", ", @fail);
            }
        }
    },
    dont_create_database => TRUE,
    do_not_die_on_fail   => TRUE,
    user                 => 'yndx-developer',
);
