#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

# use Test::Most;
use Test::More;
use Test::Partner2::Mock;
use Test::Differences;
use Test::Deep;
use Test::Partner::Utils;

use qbit;

sub main_test {
    my ($app) = @_;

    mock_curdate('2021-07-07 12:21:31');
    mock_java_jsonapi($app, 'app');

    my @call_args;
    mock_subs(
        {
            'SOAP::Data::TO_JSON' => sub {
                my ($value) = @_;
                my %tmp = %$value;
                return \%tmp;
            },
            'Application::Model::API::Yandex::SelfService::call' => sub {
                my ($self, $method, %params) = @_;
                my $content = from_json(delete $params{':content'});
                my @payload = map {from_json($_)} @{delete $content->{payload}};
                $payload[0]{Data} = from_json($payload[0]{Data});
                push @call_args,
                  {
                    package => 'SelfService',
                    method  => $method,
                    params  => \%params,
                    content => $content,
                    payload => \@payload,
                  };
            },
            'QBit::Application::Model::API::SOAP::call' => sub {
                my ($self, $func, @opts) = @_;
                push @call_args,
                  {
                    package => 'SOAP',
                    method  => $func,
                    params  => \@opts,
                  };
                return [
                    {
                        '0' => {
                            Error  => '0',
                            PageID => '142898',
                        },
                    }
                ];
            },
        }
    );

    $app->context_on_site_campaign->do_action(142898, 'set_need_update');
    $app->context_on_site_campaign->update_in_bk({id => 142898});

    my $expected = get_test_data_and_update_if_needed("data.json", \@call_args, blessed => 1);
    cmp_deeply(from_json(to_json(\@call_args, blessed => 1)), $expected, 'compare');
}

run_tests(
    \&main_test,
    do_not_die_on_fail => TRUE,
    user               => 'yndx-developer',
    mocks              => {mock_selfservice => FALSE},
    init               => [qw(api_bk api_selfservice)]
);
